/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.kv.CoreRangeScan;
import com.couchbase.client.core.kv.CoreRangeScanId;
import com.couchbase.client.core.kv.CoreSamplingScan;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.PredeterminedPartitionRequest;
import com.couchbase.client.core.msg.kv.RangeScanCreateResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class RangeScanCreateRequest
extends PredeterminedPartitionRequest<RangeScanCreateResponse> {
    private static final Random random = new Random();
    private final byte[] startTerm;
    private final boolean startExclusive;
    private final byte[] endTerm;
    private final boolean endExclusive;
    private final long limit;
    private final long seed;
    private final boolean keyOnly;
    private final Optional<MutationToken> mutationToken;

    public static RangeScanCreateRequest forRangeScan(byte[] startTerm, CoreRangeScan rangeScan, CoreScanOptions options, short partition, CoreContext ctx, CollectionIdentifier collectionIdentifier, Map<Short, MutationToken> consistencyMap) {
        return new RangeScanCreateRequest(startTerm, rangeScan.from().exclusive(), rangeScan.to().id().getBytes(StandardCharsets.UTF_8), rangeScan.to().exclusive(), 0L, Optional.empty(), options.idsOnly(), options.commonOptions().timeout().orElse(ctx.environment().timeoutConfig().kvScanTimeout()), ctx, options.commonOptions().retryStrategy().orElse(ctx.environment().retryStrategy()), collectionIdentifier, ctx.coreResources().requestTracer().requestSpan("range_scan_create", options.commonOptions().parentSpan().orElse(null)), partition, Optional.ofNullable(consistencyMap.get(partition)));
    }

    public static RangeScanCreateRequest forSamplingScan(CoreSamplingScan samplingScan, CoreScanOptions options, short partition, CoreContext ctx, CollectionIdentifier collectionIdentifier, Map<Short, MutationToken> consistencyMap) {
        return new RangeScanCreateRequest(null, false, null, false, samplingScan.limit(), samplingScan.seed(), options.idsOnly(), options.commonOptions().timeout().orElse(ctx.environment().timeoutConfig().kvScanTimeout()), ctx, options.commonOptions().retryStrategy().orElse(ctx.environment().retryStrategy()), collectionIdentifier, ctx.coreResources().requestTracer().requestSpan("range_scan_create", options.commonOptions().parentSpan().orElse(null)), partition, Optional.ofNullable(consistencyMap.get(partition)));
    }

    private RangeScanCreateRequest(byte[] startTerm, boolean startExclusive, byte[] endTerm, boolean endExclusive, long limit, Optional<Long> seed, boolean keyOnly, Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, CollectionIdentifier collectionIdentifier, RequestSpan span, short partition, Optional<MutationToken> mutationToken) {
        super(partition, timeout, ctx, retryStrategy, null, collectionIdentifier, span);
        this.startTerm = startTerm;
        this.startExclusive = startExclusive;
        this.endTerm = endTerm;
        this.endExclusive = endExclusive;
        this.limit = limit;
        this.keyOnly = keyOnly;
        this.mutationToken = mutationToken;
        this.seed = seed.orElse(random.nextLong()) & Long.MAX_VALUE;
    }

    private boolean isRangeScanFlavour() {
        return this.startTerm != null && this.endTerm != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        byte[] encodedCollectionId = ctx.collectionMap().get(this.collectionIdentifier());
        if (encodedCollectionId == null) {
            throw CollectionNotFoundException.forCollection(this.collectionIdentifier().collection().orElse(""));
        }
        long collectionId = UnsignedLEB128.decode(encodedCollectionId);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (collectionId != 0L) {
            payload.put("collection", Long.toHexString(collectionId));
        }
        if (this.keyOnly) {
            payload.put("key_only", true);
        }
        this.mutationToken.ifPresent(token -> payload.put("snapshot_requirements", CbCollections.mapOf("vb_uuid", Long.toString(token.partitionUUID()), "seqno", token.sequenceNumber(), "timeout_ms", Math.toIntExact(this.timeout().toMillis()))));
        if (this.isRangeScanFlavour()) {
            payload.put("range", CbCollections.mapOf(this.startExclusive ? "excl_start" : "start", Base64.getEncoder().encodeToString(this.startTerm), this.endExclusive ? "excl_end" : "end", Base64.getEncoder().encodeToString(this.endTerm)));
        } else {
            payload.put("sampling", CbCollections.mapOf("samples", this.limit, "seed", this.seed));
        }
        ByteBuf body = Unpooled.wrappedBuffer(Mapper.encodeAsBytes(payload));
        try {
            ByteBuf byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.RANGE_SCAN_CREATE, MemcacheProtocol.Datatype.JSON.datatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), body);
            return byteBuf;
        }
        finally {
            body.release();
        }
    }

    @Override
    public RangeScanCreateResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        ByteBuf body = MemcacheProtocol.body(response).orElse(Unpooled.EMPTY_BUFFER);
        CoreRangeScanId scanId = status.success() ? new CoreRangeScanId(body) : null;
        return new RangeScanCreateResponse(status, scanId);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    public String toString() {
        return "RangeScanCreateRequest{startTerm=" + RedactableArgument.redactUser(Arrays.toString(this.startTerm)) + ", startExclusive=" + this.startExclusive + ", endTerm=" + RedactableArgument.redactUser(Arrays.toString(this.endTerm)) + ", endExclusive=" + this.endExclusive + ", limit=" + this.limit + ", seed=" + this.seed + ", keyOnly=" + this.keyOnly + ", mutationToken=" + RedactableArgument.redactMeta(this.mutationToken) + '}';
    }
}

