/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public interface NetworkSelector {
    public static final NetworkSelector DEFAULT = NetworkSelector.create(NetworkResolution.DEFAULT, Collections.emptySet());
    public static final NetworkSelector EXTERNAL = NetworkSelector.create(NetworkResolution.EXTERNAL, Collections.emptySet());

    public NetworkResolution selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> var1);

    public static NetworkSelector create(final NetworkResolution network, Set<SeedNode> seedNodes) {
        if (network.equals(NetworkResolution.AUTO)) {
            return new AutoNetworkSelector(seedNodes);
        }
        return new NetworkSelector(){

            @Override
            public NetworkResolution selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
                return network;
            }

            public String toString() {
                return network.name();
            }
        };
    }

    public static NetworkSelector autoDetect(Set<SeedNode> seedNodes) {
        return NetworkSelector.create(NetworkResolution.AUTO, seedNodes);
    }

    public static class AutoNetworkSelector
    implements NetworkSelector {
        private static final Logger log = LoggerFactory.getLogger(AutoNetworkSelector.class);
        private final Set<SeedNode> seedNodes;
        private @Nullable NetworkResolution cachedResult;
        private boolean usedFallback;

        public AutoNetworkSelector(Set<SeedNode> seedNodes) {
            this.seedNodes = CbCollections.setCopyOf(seedNodes);
        }

        @Override
        public synchronized NetworkResolution selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
            if (this.cachedResult == null) {
                this.cachedResult = this.doSelectNetwork(nodes);
            }
            return this.cachedResult;
        }

        public synchronized String toString() {
            String network = this.cachedResult == null ? "<TBD>" : (this.usedFallback ? "no match -> " : "") + this.cachedResult.name();
            return "auto(" + network + "; seedNodes=" + this.seedNodes + ")";
        }

        private NetworkResolution doSelectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
            for (Map<NetworkResolution, HostAndServicePorts> node : nodes) {
                for (Map.Entry<NetworkResolution, HostAndServicePorts> entry : node.entrySet()) {
                    for (SeedNode seedNode : this.seedNodes) {
                        if (!entry.getValue().matches(seedNode)) continue;
                        NetworkResolution exactMatch = entry.getKey();
                        log.debug("Found exact match for {} in network '{}'", (Object)seedNode, (Object)exactMatch);
                        return exactMatch;
                    }
                }
            }
            NetworkResolution fallback = nodes.stream().anyMatch(it -> it.containsKey(NetworkResolution.EXTERNAL)) ? NetworkResolution.EXTERNAL : NetworkResolution.DEFAULT;
            log.info("Automatic network selection was requested, but no bootstrap address exactly matches an address in the cluster topology. Falling back to network: {}", (Object)fallback);
            this.usedFallback = true;
            return fallback;
        }
    }
}

