/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import java.time.Duration;
import java.util.Objects;

@Stability.Internal
public class CoreTransactionResult {
    private final CoreTransactionLogger log;
    private final Duration timeTaken;
    private final String transactionId;
    private final boolean unstagingComplete;

    CoreTransactionResult(CoreTransactionLogger log, Duration timeTaken, String transactionId, boolean unstagingComplete) {
        this.log = Objects.requireNonNull(log);
        this.timeTaken = Objects.requireNonNull(timeTaken);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.unstagingComplete = unstagingComplete;
    }

    public CoreTransactionLogger log() {
        return this.log;
    }

    public Duration timeTaken() {
        return this.timeTaken;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public boolean unstagingComplete() {
        return this.unstagingComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionResult{");
        sb.append("unstagingComplete=");
        sb.append(this.unstagingComplete);
        sb.append(",totalTime=");
        sb.append(this.timeTaken.toMillis());
        sb.append("millis");
        sb.append("}");
        return sb.toString();
    }
}

