/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreViewIndexManager;
import com.couchbase.client.java.manager.view.View;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Stability.Volatile
public class DesignDocument {
    private String name;
    private Map<String, View> views;

    public DesignDocument(String name) {
        this(name, Collections.emptyMap());
    }

    public DesignDocument(String name, Map<String, View> views) {
        this.name(name);
        this.views(views);
    }

    public String name() {
        return this.name;
    }

    public Map<String, View> views() {
        return this.views;
    }

    public DesignDocument putView(String name, String map) {
        return this.putView(name, map, null);
    }

    public DesignDocument putView(String name, String map, String reduce) {
        return this.putView(name, new View(map, reduce));
    }

    public DesignDocument putView(String name, View view) {
        this.views.put(name, view);
        return this;
    }

    public Optional<View> getView(String name) {
        return Optional.ofNullable(this.views.get(name));
    }

    public DesignDocument removeView(String name) {
        this.views.remove(name);
        return this;
    }

    public DesignDocument name(String name) {
        this.name = CoreViewIndexManager.requireUnqualifiedName((String)name);
        return this;
    }

    public DesignDocument views(Map<String, View> views) {
        this.views = new HashMap<String, View>(views);
        return this;
    }

    public String toString() {
        return "DesignDocument{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", views=" + RedactableArgument.redactMeta(this.views) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesignDocument that = (DesignDocument)o;
        return this.name.equals(that.name) && this.views.equals(that.views);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

