/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.config.sink;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.util.Keyspace;
import com.couchbase.connect.kafka.util.TopicMap;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.Contextual;
import com.couchbase.connect.kafka.util.config.annotation.ContextDocumentation;
import com.couchbase.connect.kafka.util.config.annotation.Default;
import java.time.Duration;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;

public interface SinkBehaviorConfig {
    public static final String CONTEXT_IS_KAFKA_TOPIC = "the name of the Kafka topic the record came from";

    @Default(value="_default._default")
    @ContextDocumentation(contextDescription="the name of the Kafka topic the record came from", sampleContext="widgets", sampleValue="inventory.widgets")
    public Contextual<String> defaultCollection();

    public static ConfigDef.Validator defaultCollectionValidator() {
        return ConfigHelper.validate(value -> Keyspace.parse(value, null), "A qualified collection name like 'scope.collection' or 'bucket.scope.collection'. If the bucket component contains a dot, escape it by enclosing it in backticks.");
    }

    @Deprecated
    @Default
    public List<String> topicToCollection();

    public static ConfigDef.Validator topicToCollectionValidator() {
        return ConfigHelper.validate(value -> TopicMap.parseTopicToCollection(value, null), "topic1=scope.collection,topic2=other-bucket.scope.collection,... If a bucket component contains a dot, escape it by enclosing it in backticks.");
    }

    @Stability.Uncommitted
    @Deprecated
    @Default
    public List<String> topicToDocumentId();

    public static ConfigDef.Validator topicToDocumentIdValidator() {
        return ConfigHelper.validate(TopicMap::parseTopicToDocumentId, "topic1=${/id},topic2=${/some/other/path},...");
    }

    @Default(value="com.couchbase.connect.kafka.handler.sink.UpsertSinkHandler")
    public Class<? extends SinkHandler> sinkHandler();

    @Default(value="DOCUMENT")
    @Deprecated
    public DocumentMode documentMode();

    @Default
    @ContextDocumentation(contextDescription="the name of the Kafka topic the record came from", sampleContext="widgets", sampleValue="widget::${/widgetId}")
    public Contextual<String> documentId();

    @Default(value="false")
    @ContextDocumentation(contextDescription="the name of the Kafka topic the record came from", sampleContext="widgets", sampleValue="true")
    public Contextual<Boolean> removeDocumentId();

    @Default(value="0")
    @ContextDocumentation(contextDescription="the name of the Kafka topic the record came from", sampleContext="alerts", sampleValue="14d")
    public Contextual<Duration> documentExpiration();

    @Default(value="0")
    public Duration retryTimeout();

    @Deprecated
    public static enum DocumentMode {
        DOCUMENT,
        SUBDOCUMENT,
        N1QL;

    }
}

