/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.util.Keyspace;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.connect.sink.SinkRecord;
import org.jspecify.annotations.Nullable;

public class SinkHandlerParams {
    private final ReactiveCluster cluster;
    private final @Nullable ReactiveCollection collection;
    private final Keyspace keyspace;
    private final SinkRecord sinkRecord;
    private final Optional<SinkDocument> document;
    private final Consumer<CommonDurabilityOptions<?>> durabilityOptions;
    private final Optional<Duration> expiry;

    public SinkHandlerParams(ReactiveCluster cluster, @Nullable ReactiveCollection collection, Keyspace keyspace, SinkRecord sinkRecord, SinkDocument document, Optional<Duration> expiry, Consumer<CommonDurabilityOptions<?>> durabilityOptions) {
        this.cluster = Objects.requireNonNull(cluster);
        this.collection = collection;
        this.keyspace = Objects.requireNonNull(keyspace);
        this.sinkRecord = Objects.requireNonNull(sinkRecord);
        this.durabilityOptions = Objects.requireNonNull(durabilityOptions);
        this.document = Optional.ofNullable(document);
        this.expiry = Objects.requireNonNull(expiry);
    }

    public ReactiveCluster cluster() {
        return this.cluster;
    }

    public ReactiveCollection collection() {
        if (this.collection == null) {
            throw new IllegalStateException("Can't call this method, because this SinkHandler's usesKvCollections() method returned false.");
        }
        return this.collection;
    }

    @Stability.Internal
    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public SinkRecord sinkRecord() {
        return this.sinkRecord;
    }

    public Optional<SinkDocument> document() {
        return this.document;
    }

    public void configureDurability(CommonDurabilityOptions<?> options) {
        this.durabilityOptions.accept(options);
    }

    public Optional<Duration> expiry() {
        return this.expiry;
    }
}

