/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.connect.kafka.config.source.CouchbaseSourceTaskConfig;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.LookupTable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.codec.binary.Base64;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Uncommitted
public class ConfigurableSchemaSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableSchemaSourceHandler.class);
    private LookupTable<ScopeAndCollection, org.apache.kafka.connect.data.Schema> valueSchemas;

    @Override
    public void init(Map<String, String> configProperties) {
        CouchbaseSourceTaskConfig config = ConfigHelper.parse(CouchbaseSourceTaskConfig.class, configProperties);
        this.valueSchemas = config.valueSchema().mapKeys(ScopeAndCollection::parse).mapValues(this::parseSchema);
    }

    private org.apache.kafka.connect.data.Schema parseSchema(String avroSchema) {
        Schema parsedValueSchema = new Schema.Parser().parse(avroSchema);
        return this.resolveSchema(parsedValueSchema);
    }

    private org.apache.kafka.connect.data.Schema resolveSchema(Schema schema, boolean optional) {
        switch (schema.getType()) {
            case INT: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA : org.apache.kafka.connect.data.Schema.INT32_SCHEMA;
            }
            case LONG: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA : org.apache.kafka.connect.data.Schema.INT64_SCHEMA;
            }
            case BYTES: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_BYTES_SCHEMA : org.apache.kafka.connect.data.Schema.BYTES_SCHEMA;
            }
            case FLOAT: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT32_SCHEMA : org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA;
            }
            case DOUBLE: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT64_SCHEMA : org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA;
            }
            case STRING: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA : org.apache.kafka.connect.data.Schema.STRING_SCHEMA;
            }
            case BOOLEAN: {
                return optional ? org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA : org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA;
            }
            case MAP: {
                org.apache.kafka.connect.data.Schema valueSchema = this.resolveSchema(schema.getValueType());
                SchemaBuilder map = SchemaBuilder.map((org.apache.kafka.connect.data.Schema)org.apache.kafka.connect.data.Schema.STRING_SCHEMA, (org.apache.kafka.connect.data.Schema)valueSchema);
                if (optional) {
                    map.optional();
                }
                return map.build();
            }
            case ARRAY: {
                org.apache.kafka.connect.data.Schema elementSchema = this.resolveSchema(schema.getElementType());
                SchemaBuilder array = SchemaBuilder.array((org.apache.kafka.connect.data.Schema)elementSchema);
                if (optional) {
                    array.optional();
                }
                return array.build();
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    if (s.getType() == Schema.Type.NULL) continue;
                    return this.resolveSchema(s, true);
                }
                return null;
            }
            case RECORD: {
                SchemaBuilder record = SchemaBuilder.struct().name(schema.getName());
                if (optional) {
                    record.optional();
                }
                for (Schema.Field field : schema.getFields()) {
                    org.apache.kafka.connect.data.Schema interiorFieldSchema = this.resolveSchema(field.schema());
                    if (interiorFieldSchema == null) continue;
                    record.field(field.name(), interiorFieldSchema);
                }
                return record;
            }
            case NULL: {
                return null;
            }
        }
        throw new ConfigException("Unsupported Type in Schema. We do not support Enum or Fixed types");
    }

    private org.apache.kafka.connect.data.Schema resolveSchema(Schema schema) {
        return this.resolveSchema(schema, false);
    }

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        org.apache.kafka.connect.data.Schema schemaToUse = this.valueSchemas.get(ScopeAndCollection.from(params.documentEvent()));
        builder.topic(params.topic());
        builder.key(params.documentEvent().key());
        try {
            Struct record = this.buildStruct(schemaToUse, params.documentEvent().content());
            this.checkStruct(schemaToUse, record);
            builder.value(schemaToUse, record);
        }
        catch (Exception e) {
            LOGGER.debug("Document doesn't match specified schema. Will not be pushed to Kafka", (Throwable)e);
            return null;
        }
        return builder;
    }

    private void checkStruct(org.apache.kafka.connect.data.Schema schema, Struct struct) {
        for (Field field : schema.fields()) {
            if (struct.get(field.name()) != null || field.schema().isOptional()) continue;
            throw new SchemaException("Document is missing required field: " + field.name());
        }
    }

    private Struct buildStruct(org.apache.kafka.connect.data.Schema schema, byte[] json) {
        return this.buildStruct(schema, JsonObject.fromJson((byte[])json));
    }

    private Struct buildStruct(org.apache.kafka.connect.data.Schema schema, JsonObject json) {
        Struct struct = new Struct(schema);
        json.getNames().forEach(name -> {
            if (schema.field(name).schema().type() == Schema.Type.STRUCT) {
                struct.put(name, (Object)this.buildStruct(schema.field(name).schema(), json.getObject(name)));
            } else if (schema.field(name).schema().type() == Schema.Type.ARRAY) {
                struct.put(name, (Object)json.getArray(name).toList());
            } else if (schema.field(name).schema().type() == Schema.Type.MAP) {
                struct.put(name, (Object)json.getObject(name).toMap());
            } else if (schema.field(name).schema().type() == Schema.Type.BYTES) {
                struct.put(name, (Object)Base64.decodeBase64((String)json.getString(name)));
            } else if (schema.field(name).schema().type() == Schema.Type.FLOAT32) {
                struct.put(name, (Object)Float.valueOf(json.getNumber(name).floatValue()));
            } else {
                struct.put(name, json.get(name));
            }
        });
        return struct;
    }
}

