/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.MutationMetadata;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.Schemas;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchemaSourceHandler.class);

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        builder.topic(params.topic());
        this.buildKey(params, builder);
        if (!this.buildValue(params, builder)) {
            return null;
        }
        return builder;
    }

    protected void buildKey(SourceHandlerParams params, SourceRecordBuilder builder) {
        builder.key(Schemas.KEY_SCHEMA, params.documentEvent().key());
    }

    protected boolean buildValue(SourceHandlerParams params, SourceRecordBuilder builder) {
        DocumentEvent docEvent = params.documentEvent();
        DocumentEvent.Type type = docEvent.type();
        Struct record = new Struct(Schemas.VALUE_DEFAULT_SCHEMA);
        record.put("event", (Object)type.schemaName());
        record.put("bucket", (Object)docEvent.bucket());
        record.put("partition", (Object)docEvent.partition());
        record.put("vBucketUuid", (Object)docEvent.partitionUuid());
        record.put("key", (Object)docEvent.key());
        record.put("cas", (Object)docEvent.cas());
        record.put("bySeqno", (Object)docEvent.bySeqno());
        record.put("revSeqno", (Object)docEvent.revisionSeqno());
        MutationMetadata mutation = docEvent.mutationMetadata().orElse(null);
        if (mutation != null) {
            record.put("expiration", (Object)mutation.expiry());
            record.put("flags", (Object)mutation.flags());
            record.put("lockTime", (Object)mutation.lockTime());
            record.put("content", (Object)docEvent.content());
        } else if (type != DocumentEvent.Type.DELETION && type != DocumentEvent.Type.EXPIRATION) {
            LOGGER.warn("unexpected event type: {}", (Object)type);
            return false;
        }
        builder.value(Schemas.VALUE_DEFAULT_SCHEMA, record);
        return true;
    }
}

