/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BatchBuilder<T> {
    private final List<List<T>> batches = new ArrayList<List<T>>();
    private final Set<ConcurrencyHint> hintsInCurrentBatch = new HashSet<ConcurrencyHint>();
    private List<T> currentBatch = null;

    public BatchBuilder<T> add(T item, ConcurrencyHint hint) {
        if (hint == ConcurrencyHint.neverConcurrent()) {
            this.doAddSingleton(item);
            return this;
        }
        if (hint != ConcurrencyHint.alwaysConcurrent() && !this.hintsInCurrentBatch.add(hint)) {
            this.insertBarrier();
            this.hintsInCurrentBatch.add(hint);
        }
        this.doAdd(item);
        return this;
    }

    public List<List<T>> build() {
        return this.batches;
    }

    private void insertBarrier() {
        this.currentBatch = null;
        this.hintsInCurrentBatch.clear();
    }

    private void doAdd(T item) {
        if (this.currentBatch == null) {
            this.currentBatch = new ArrayList<T>();
            this.batches.add(this.currentBatch);
        }
        this.currentBatch.add(item);
    }

    private void doAddSingleton(T item) {
        this.batches.add(Collections.singletonList(item));
        this.insertBarrier();
    }

    public String toString() {
        return "BatchBuilder{hintsInCurrentBatch=" + this.hintsInCurrentBatch + ", batches=" + this.batches + ", currentBatch=" + this.currentBatch + '}';
    }
}

