/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListHelper {
    private ListHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T> List<List<T>> chunks(List<T> items, int chunks) {
        if (chunks <= 0) {
            throw new IllegalArgumentException("chunks must be > 0");
        }
        Objects.requireNonNull(items);
        int maxChunkSize = (items.size() - 1) / chunks + 1;
        int numFullChunks = chunks - (maxChunkSize * chunks - items.size());
        ArrayList<List<T>> result = new ArrayList<List<T>>(chunks);
        int startIndex = 0;
        for (int i = 0; i < chunks; ++i) {
            int endIndex = startIndex + maxChunkSize;
            if (i >= numFullChunks) {
                --endIndex;
            }
            result.add(items.subList(startIndex, endIndex));
            startIndex = endIndex;
        }
        return result;
    }
}

