/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import com.couchbase.connect.kafka.util.config.DataSize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSizeParser {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)(.+)");
    private static final Map<String, Integer> qualifierToScale;

    private DataSizeParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static DataSize parseDataSize(String s) {
        if ((s = s.trim().toLowerCase(Locale.ROOT)).equals("0")) {
            return DataSize.ofBytes(0L);
        }
        Matcher m = PATTERN.matcher(s);
        if (!m.matches() || !qualifierToScale.containsKey(m.group(2))) {
            throw new IllegalArgumentException("Unable to parse size '" + s + "'. Please specify an integer followed by a size unit (b = bytes, k = kilobytes, m = megabytes, g = gigabytes). For example, to specify 64 megabytes: 64m");
        }
        long value = Long.parseLong(m.group(1));
        Integer unit = qualifierToScale.get(m.group(2));
        return DataSize.ofBytes(value * (long)unit.intValue());
    }

    static {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        temp.put("b", 1);
        temp.put("k", 1024);
        temp.put("m", 0x100000);
        temp.put("g", 0x40000000);
        qualifierToScale = Collections.unmodifiableMap(temp);
    }
}

