/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.reporter;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryCollector;
import com.couchbase.client.core.cnc.apptelemetry.reporter.AppTelemetryWebSocketHandler;
import com.couchbase.client.core.deps.io.netty.bootstrap.Bootstrap;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.socket.SocketChannel;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaders;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import com.couchbase.client.core.deps.io.netty.handler.timeout.IdleStateHandler;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.error.SecurityException;
import com.couchbase.client.core.io.netty.SslHandlerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppTelemetryWebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(AppTelemetryWebSocketClient.class);
    private static final Duration pingInterval = Duration.ofMinutes(15L);
    private static final Duration idleTimeout = pingInterval.plus(Duration.ofMinutes(1L));
    private final AppTelemetryCollector collector;
    private final CoreContext coreContext;

    AppTelemetryWebSocketClient(CoreContext coreContext, AppTelemetryCollector collector) {
        this.coreContext = Objects.requireNonNull(coreContext);
        this.collector = Objects.requireNonNull(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectAndWaitForClose(URI remote, Runnable doOnSuccessfulConnection) throws InterruptedException {
        try (Channel channel = null;){
            channel = this.newChannel(remote, doOnSuccessfulConnection);
            channel.closeFuture().sync();
        }
    }

    private static int getPort(URI webSocketUri) {
        int port = webSocketUri.getPort();
        if (port != -1) {
            return port;
        }
        switch (webSocketUri.getScheme()) {
            case "ws": {
                return 80;
            }
            case "wss": {
                return 443;
            }
        }
        throw new IllegalArgumentException("Unsupported websocket scheme: " + webSocketUri.getScheme());
    }

    private Channel newChannel(URI uri, Runnable doOnSuccessfulConnection) {
        final String host = uri.getHost();
        final int port = AppTelemetryWebSocketClient.getPort(uri);
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        this.maybeAuthenticate(headers);
        final AppTelemetryWebSocketHandler handler = new AppTelemetryWebSocketHandler(WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, null, true, headers), this.collector);
        EventLoopGroup group = this.coreContext.environment().ioEnvironment().managerEventLoopGroup().get();
        int connectTimeoutMillis = (int)this.coreContext.environment().timeoutConfig().connectTimeout().toMillis();
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(BaseEndpoint.channelFrom(group))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeoutMillis)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                AppTelemetryWebSocketClient.this.maybeAddTlsHandler(ch, new HostAndPort(host, port));
                p.addLast(new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, new IdleStateHandler(idleTimeout.toMillis(), pingInterval.toMillis(), 0L, TimeUnit.MILLISECONDS), handler);
            }
        });
        ChannelFuture connectFuture = b.connect(host, port);
        connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (future.isSuccess()) {
                log.info("App telemetry connection established for remote: {}", (Object)RedactableArgument.redactSystem(uri));
                handler.handshakeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)f -> {
                    if (f.isSuccess()) {
                        log.info("WebSocket handshake successful for remote: {}", (Object)RedactableArgument.redactSystem(uri));
                        doOnSuccessfulConnection.run();
                    } else {
                        log.warn("WebSocket handshake failed for remote: {}", (Object)RedactableArgument.redactSystem(uri));
                        connectFuture.channel().close();
                    }
                }));
            } else {
                log.warn("App telemetry connection failed for remote: {}", (Object)RedactableArgument.redactSystem(uri), (Object)future.cause());
            }
        }));
        return connectFuture.channel();
    }

    private boolean isUserSpecifiedEndpoint() {
        return this.coreContext.environment().appTelemetryEndpoint() != null;
    }

    private void maybeAuthenticate(HttpHeaders headers) {
        if (this.isUserSpecifiedEndpoint()) {
            return;
        }
        DefaultHttpRequest dummyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.coreContext.authenticator().authHttpRequest(ServiceType.MANAGER, dummyRequest);
        headers.add(dummyRequest.headers());
    }

    private void maybeAddTlsHandler(SocketChannel ch, HostAndPort remote) {
        if (this.isUserSpecifiedEndpoint()) {
            return;
        }
        SecurityConfig config = this.coreContext.environment().securityConfig();
        if (config.tlsEnabled()) {
            try {
                EndpointContext ctx = this.newEndpointContext(remote);
                ch.pipeline().addFirst(SslHandlerFactory.get(ch.alloc(), config, ctx));
            }
            catch (Exception e) {
                throw new SecurityException("Could not instantiate SSL Handler", e);
            }
        }
    }

    private EndpointContext newEndpointContext(HostAndPort remote) {
        return new EndpointContext(this.coreContext, remote, null, ServiceType.MANAGER, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

