/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.config.ConfigVersion;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.UnmonitoredRequest;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.CarrierGlobalConfigResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.topology.NodeIdentifier;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class CarrierGlobalConfigRequest
extends BaseKeyValueRequest<CarrierGlobalConfigResponse>
implements TargetedRequest,
UnmonitoredRequest {
    private final NodeIdentifier target;
    private final ConfigVersion ifNewerThan;

    public CarrierGlobalConfigRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, NodeIdentifier target, @Nullable ConfigVersion ifNewerThan) {
        super(timeout, ctx, retryStrategy, null, null);
        this.target = target;
        this.ifNewerThan = Optional.ofNullable(ifNewerThan).orElse(ConfigVersion.ZERO);
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        return CarrierGlobalConfigRequest.encodeConfigRequest(alloc, opaque, ctx, this.ifNewerThan);
    }

    static ByteBuf encodeConfigRequest(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx, ConfigVersion ifNewerThan) {
        return MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET_CONFIG, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), opaque, MemcacheProtocol.noCas(), CarrierGlobalConfigRequest.requestExtras(ifNewerThan, ctx), MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
    }

    private static ByteBuf requestExtras(ConfigVersion ifNewerThan, KeyValueChannelContext ctx) {
        if (!ctx.getClusterConfigWithKnownVersion() || ifNewerThan.isLessThanOrEqualTo(ConfigVersion.ZERO)) {
            return MemcacheProtocol.noExtras();
        }
        return Unpooled.buffer(16).writeLong(ifNewerThan.epoch()).writeLong(ifNewerThan.rev());
    }

    @Override
    public CarrierGlobalConfigResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        byte[] content = MemcacheProtocol.bodyAsBytes(response);
        return new CarrierGlobalConfigResponse(MemcacheProtocol.decodeStatus(response), content);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> ctx = super.serviceContext();
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target));
        }
        return ctx;
    }

    @Override
    public String name() {
        return "carrier_global_config";
    }

    public String toString() {
        return "CarrierGlobalConfigRequest{target=" + RedactableArgument.redactSystem(this.target) + ", ifNewerThan=" + this.ifNewerThan + '}';
    }
}

