/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.ResponseStatus;
import java.util.HashMap;
import java.util.Objects;

public class ResponseStatusDetails {
    private static final TypeReference<HashMap<String, HashMap<String, String>>> JACKSON_TYPEREF = new TypeReference<HashMap<String, HashMap<String, String>>>(){};
    private final String reference;
    private final String context;

    public static ResponseStatusDetails convert(byte[] input) {
        if (input.length == 0) {
            return null;
        }
        try {
            HashMap<String, HashMap<String, String>> result = Mapper.decodeInto(input, JACKSON_TYPEREF);
            HashMap<String, String> errorMap = result.get("error");
            if (errorMap == null) {
                return null;
            }
            return new ResponseStatusDetails(errorMap.get("ref"), errorMap.get("context"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    ResponseStatusDetails(String reference, String context) {
        this.reference = reference;
        this.context = context;
    }

    public String reference() {
        return this.reference;
    }

    public String context() {
        return this.context;
    }

    public String toString() {
        return "ResponseStatusDetails{reference='" + this.reference + '\'' + ", context='" + this.context + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseStatusDetails that = (ResponseStatusDetails)o;
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        return Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        int result = this.reference != null ? this.reference.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    public static String stringify(ResponseStatus status, ResponseStatusDetails details) {
        String result = status.toString();
        if (details != null) {
            result = result + " (Context: " + details.context() + ", Reference: " + details.reference() + ")";
        }
        return result;
    }
}

