/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.transaction.util.DebugUtil;
import java.util.Objects;

@Stability.Internal
public class LogDeferThrowable {
    private final Throwable err;

    public LogDeferThrowable(Throwable err) {
        this.err = Objects.requireNonNull(err);
    }

    public String toString() {
        StringBuilder out = new StringBuilder(RedactableArgument.redactUser(this.err.toString()).toString());
        if (this.err.getCause() == null) {
            out.append(" no cause");
        } else {
            out.append(" cause: ");
            out.append(RedactableArgument.redactUser(this.err.getCause().toString()));
        }
        out.append(" stacktrace: ");
        out.append(DebugUtil.createElidedStacktrace(this.err));
        return out.toString().trim();
    }
}

