/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.conductor;

import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.node.StandardMemcachedHashingStrategy;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.TopologyParser;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.buffer.DcpBucketConfig;
import com.couchbase.client.dcp.conductor.BucketConfigSink;
import com.couchbase.client.dcp.conductor.BucketConfigSource;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.ReplayProcessor;

public class BucketConfigArbiter
implements BucketConfigSink,
BucketConfigSource {
    private static final Logger log = LoggerFactory.getLogger(BucketConfigArbiter.class);
    private final ReplayProcessor<DcpBucketConfig> configStream = ReplayProcessor.cacheLast();
    private final FluxSink<DcpBucketConfig> configSink = this.configStream.sink(FluxSink.OverflowStrategy.LATEST);
    private final Object revLock = new Object();
    private TopologyRevision currentRev = TopologyRevision.ZERO;
    private final Client.Environment environment;
    private static final Pattern REV_PATTERN = Pattern.compile("\"rev\"\\s*:\\s*(-?\\d+)");
    private static final Pattern REV_EPOCH_PATTERN = Pattern.compile("\"revEpoch\"\\s*:\\s*(-?\\d+)");

    public BucketConfigArbiter(Client.Environment environment) {
        this.environment = Objects.requireNonNull(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(HostAndPort origin, String rawConfig, TopologyRevision rev) {
        Object object = this.revLock;
        synchronized (object) {
            if (!rev.newerThan(this.currentRev)) {
                log.debug("Ignoring config revision {} from {}; not newer than current revision {}", new Object[]{rev, origin, this.currentRev});
                return;
            }
            log.debug("Received config revision {} from {} -> {}", new Object[]{rev, origin, RedactableArgument.redactSystem(rawConfig)});
            if (!rawConfig.contains("\"nodeLocator\"")) {
                log.info("Received a global config (revision {}). Ignoring it, because a global config doesn't have info about the bucket. Waiting for a bucket config instead!", (Object)rev);
                return;
            }
            try {
                this.currentRev = rev;
                TopologyParser parser = new TopologyParser(this.environment.networkSelector(), this.environment.portSelector(), (MemcachedHashingStrategy)StandardMemcachedHashingStrategy.INSTANCE);
                ClusterTopologyWithBucket config = parser.parse(rawConfig, origin.host()).requireBucket();
                this.configSink.next((Object)new DcpBucketConfig(config));
            }
            catch (Exception e) {
                log.error("Failed to parse bucket config", (Throwable)e);
            }
        }
    }

    @Override
    public void accept(HostAndPort origin, String rawConfig) {
        try {
            this.accept(origin, rawConfig, BucketConfigArbiter.getRev(rawConfig));
        }
        catch (Exception e) {
            log.error("Failed to parse bucket config", (Throwable)e);
        }
    }

    @Override
    public Flux<DcpBucketConfig> configs() {
        return this.configStream;
    }

    private static OptionalLong matchLong(Pattern pattern, String s) {
        Matcher m = pattern.matcher(s);
        return m.find() ? OptionalLong.of(Long.parseLong(m.group(1))) : OptionalLong.empty();
    }

    private static TopologyRevision getRev(String rawConfig) {
        long rev = BucketConfigArbiter.matchLong(REV_PATTERN, rawConfig).orElseThrow(() -> new IllegalArgumentException("Failed to locate revision property in " + RedactableArgument.redactSystem(rawConfig)));
        long epoch = BucketConfigArbiter.matchLong(REV_EPOCH_PATTERN, rawConfig).orElse(0L);
        return new TopologyRevision(epoch, rev);
    }
}

