/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.time;

import com.couchbase.client.dcp.core.time.Delay;
import java.util.concurrent.TimeUnit;

public class ExponentialDelay
extends Delay {
    private final long lower;
    private final long upper;
    private final double growBy;
    private final int powersOf;

    ExponentialDelay(TimeUnit unit, long upper, long lower, double growBy, int powersOf) {
        super(unit);
        if (lower > upper) {
            throw new IllegalArgumentException("The lower value must be smaller or equal to the upper value!");
        }
        this.lower = lower;
        this.upper = upper;
        this.growBy = growBy;
        this.powersOf = powersOf <= 2 ? 2 : powersOf;
    }

    @Override
    public long calculate(long attempt) {
        long calc = attempt <= 0L ? 0L : (this.powersOf == 2 ? this.calculatePowerOfTwo(attempt) : this.calculateAlternatePower(attempt));
        return this.applyBounds(calc);
    }

    protected long calculateAlternatePower(long attempt) {
        double step = Math.pow(this.powersOf, attempt - 1L);
        return Math.round(step * this.growBy);
    }

    protected long calculatePowerOfTwo(long attempt) {
        long step = attempt >= 64L ? Long.MAX_VALUE : 1L << (int)(attempt - 1L);
        return Math.round((double)step * this.growBy);
    }

    private long applyBounds(long calculatedValue) {
        if (calculatedValue < this.lower) {
            return this.lower;
        }
        if (calculatedValue > this.upper) {
            return this.upper;
        }
        return calculatedValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExponentialDelay{");
        sb.append("growBy ").append(this.growBy);
        sb.append(" " + (Object)((Object)this.unit()));
        sb.append(", powers of ").append(this.powersOf);
        sb.append("; lower=").append(this.lower);
        sb.append(", upper=").append(this.upper);
        sb.append('}');
        return sb.toString();
    }
}

