/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.events;

import com.couchbase.client.dcp.core.event.CouchbaseEvent;
import com.couchbase.client.dcp.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;

public class DefaultDcpEventBus
implements EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDcpEventBus.class);
    private final FluxProcessor<CouchbaseEvent, CouchbaseEvent> bus = DirectProcessor.create();
    private final FluxSink<CouchbaseEvent> sink = this.bus.sink(FluxSink.OverflowStrategy.BUFFER);
    private final Scheduler scheduler;

    public DefaultDcpEventBus(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Flux<CouchbaseEvent> get() {
        return this.bus.onBackpressureBuffer().publishOn(this.scheduler);
    }

    @Override
    public void publish(CouchbaseEvent event) {
        try {
            this.sink.next((Object)event);
        }
        catch (Exception ex) {
            LOGGER.warn("Caught exception during event emission, moving on.", (Throwable)ex);
        }
    }
}

