/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultDropwizardConfig
implements DropwizardConfig {
    private final String prefix;
    private final Function<String, String> configValueAccessor;
    public static final HierarchicalNameMapper PRETTY_TAGS = (id, convention) -> {
        List tags;
        String base = id.getConventionName(convention);
        if (base.startsWith("dcp")) {
            base = "dcp." + Character.toLowerCase(base.charAt(3)) + base.substring(4);
        }
        if ((tags = id.getConventionTags(convention)).isEmpty()) {
            return base;
        }
        return base + "{" + tags.stream().map(t -> t.getKey() + "=" + t.getValue()).map(nameSegment -> nameSegment.replace(" ", "_")).collect(Collectors.joining(",")) + "}";
    };

    public DefaultDropwizardConfig() {
        this("dropwizard", (String key) -> null);
    }

    public DefaultDropwizardConfig(String prefix, Map<String, String> config) {
        this(prefix, config::get);
    }

    public DefaultDropwizardConfig(String prefix, Properties config) {
        this(prefix, config::getProperty);
    }

    public DefaultDropwizardConfig(String prefix, Function<String, String> configValueAccessor) {
        this.prefix = Objects.requireNonNull(prefix);
        this.configValueAccessor = Objects.requireNonNull(configValueAccessor);
    }

    public String prefix() {
        return this.prefix;
    }

    public String get(String key) {
        return this.configValueAccessor.apply(key);
    }
}

