/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import java.util.Map;
import java.util.Objects;

class SourceOffset {
    private final StreamOffset streamOffset;

    public SourceOffset(StreamOffset offset) {
        this.streamOffset = Objects.requireNonNull(offset);
    }

    public SourceOffset withVbucketUuid(long vbucketUuid) {
        return new SourceOffset(new StreamOffset(vbucketUuid, this.streamOffset.getSeqno(), this.streamOffset.getSnapshot(), this.streamOffset.getCollectionsManifestUid()));
    }

    public StreamOffset asStreamOffset() {
        return this.streamOffset;
    }

    public Map<String, Object> toMap() {
        return CbCollections.mapOf((Object)"bySeqno", (Object)this.streamOffset.getSeqno(), (Object)"vbuuid", (Object)this.streamOffset.getVbuuid(), (Object)"snapshotStartSeqno", (Object)this.streamOffset.getSnapshot().getStartSeqno(), (Object)"snapshotEndSeqno", (Object)this.streamOffset.getSnapshot().getEndSeqno(), (Object)"collectionsManifestUid", (Object)this.streamOffset.getCollectionsManifestUid());
    }

    public static SourceOffset fromMap(Map<String, Object> map) {
        long seqno = (Long)map.get("bySeqno");
        return new SourceOffset(new StreamOffset(((Long)map.getOrDefault("vbuuid", 0L)).longValue(), seqno, new SnapshotMarker(((Long)map.getOrDefault("snapshotStartSeqno", seqno)).longValue(), ((Long)map.getOrDefault("snapshotEndSeqno", seqno)).longValue()), ((Long)map.getOrDefault("collectionsManifestUid", 0L)).longValue()));
    }

    public String toString() {
        return this.streamOffset.toString();
    }
}

