/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.connect.kafka.config.sink.CouchbaseSinkConfig;
import com.couchbase.connect.kafka.config.sink.N1qlSinkHandlerConfig;
import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.handler.sink.SinkAction;
import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerContext;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerParams;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class N1qlSinkHandler
implements SinkHandler {
    private static final Logger log = LoggerFactory.getLogger(N1qlSinkHandler.class);
    private static final String ID_FIELD = "__id__";
    private N1qlSinkHandlerConfig.Operation mode;
    protected String conditions;
    protected boolean createDocuments;
    protected String bucketName;

    static Map<String, String> withAlias(Map<String, String> properties, String canonicalPropertyName, String aliasPropertyName) {
        HashMap<String, String> copy = new HashMap<String, String>(properties);
        String aliasValue = (String)copy.get(aliasPropertyName);
        String canonicalValue = (String)copy.get(canonicalPropertyName);
        if (canonicalValue == null && aliasValue != null) {
            copy.put(canonicalPropertyName, aliasValue);
        }
        return copy;
    }

    @Override
    public void init(SinkHandlerContext context) {
        Map<String, String> properties = N1qlSinkHandler.withAlias(context.configProperties(), ConfigHelper.keyName(N1qlSinkHandlerConfig.class, N1qlSinkHandlerConfig::n1qlCreateDocument), "couchbase.create.document");
        CouchbaseSinkConfig config = ConfigHelper.parse(CouchbaseSinkConfig.class, properties);
        this.mode = config.n1qlOperation();
        this.conditions = N1qlSinkHandler.conditions(config.n1qlWhereFields());
        this.createDocuments = config.n1qlCreateDocument();
        this.bucketName = config.bucket();
        if (this.mode == N1qlSinkHandlerConfig.Operation.UPDATE_WHERE && this.conditions.isEmpty()) {
            String keyName = ConfigHelper.keyName(N1qlSinkHandlerConfig.class, N1qlSinkHandlerConfig::n1qlWhereFields);
            throw new ConfigException("Missing required configuration \"" + keyName + "\".");
        }
    }

    @Override
    public SinkAction handle(SinkHandlerParams params) {
        JsonObject node;
        String documentId = this.getDocumentId(params);
        SinkDocument doc = params.document().orElse(null);
        String keySpace = N1qlSinkHandler.keyspace(params);
        if (doc == null) {
            return SinkAction.remove(params, params.collection(), documentId);
        }
        try {
            node = JsonObject.fromJson((byte[])doc.content());
        }
        catch (Exception e) {
            log.warn("could not generate n1ql statement from node (not json)", (Throwable)e);
            return SinkAction.ignore();
        }
        if (node.isEmpty()) {
            log.warn("could not generate n1ql statement from empty node");
            return SinkAction.ignore();
        }
        for (String name : node.getNames()) {
            if (!name.contains("`")) continue;
            log.warn("could not generate n1ql statement from node with backtick (`) in field name");
            return SinkAction.ignore();
        }
        String statement = this.getStatement(keySpace, node);
        node.put(ID_FIELD, documentId);
        Mono action = Mono.defer(() -> params.cluster().query(statement, QueryOptions.queryOptions().parameters(node)).map(ReactiveQueryResult::metaData));
        ConcurrencyHint concurrencyHint = this.mode == N1qlSinkHandlerConfig.Operation.UPDATE ? ConcurrencyHint.of(documentId) : ConcurrencyHint.neverConcurrent();
        return new SinkAction((Publisher<?>)action, concurrencyHint);
    }

    protected static String keyspace(SinkHandlerParams params) {
        boolean defaultCollection;
        ReactiveCollection c = params.collection();
        String bucket = c.bucketName();
        String scope = N1qlSinkHandler.defaultIfEmpty(c.scopeName(), "_default");
        String collection = N1qlSinkHandler.defaultIfEmpty(c.name(), "_default");
        ArrayList<String> components = new ArrayList<String>();
        components.add(bucket);
        boolean bl = defaultCollection = scope.equals("_default") && collection.equals("_default");
        if (!defaultCollection) {
            components.add(scope);
            components.add(collection);
        }
        return components.stream().map(it -> "`" + it + "`").collect(Collectors.joining("."));
    }

    private static String defaultIfEmpty(String s, String defaultValue) {
        return s.isEmpty() ? defaultValue : s;
    }

    private String getStatement(String keySpace, JsonObject kafkaMessage) {
        switch (this.mode) {
            case UPDATE_WHERE: {
                return this.updateWithConditionStatement(keySpace, kafkaMessage);
            }
            case UPDATE: {
                return this.createDocuments ? this.mergeStatement(keySpace, kafkaMessage) : this.updateStatement(keySpace, kafkaMessage);
            }
        }
        throw new AssertionError((Object)"unrecognized n1ql mode");
    }

    private String updateStatement(String keySpace, JsonObject values) {
        return "UPDATE " + keySpace + " USE KEYS $" + ID_FIELD + " SET " + N1qlSinkHandler.assignments(values) + " RETURNING meta().id;";
    }

    private String updateWithConditionStatement(String keySpace, JsonObject values) {
        return "UPDATE " + keySpace + " SET " + N1qlSinkHandler.assignments(values) + " WHERE " + this.conditions + " RETURNING meta().id;";
    }

    private String mergeStatement(String keyspace, JsonObject values) {
        return "MERGE INTO " + keyspace + " AS doc USING 1 AS o ON KEY $" + ID_FIELD + " WHEN MATCHED THEN UPDATE SET " + N1qlSinkHandler.assignments(values, "doc.") + " WHEN NOT MATCHED THEN INSERT " + values;
    }

    private static String assignments(JsonObject values) {
        return N1qlSinkHandler.assignments(values, "");
    }

    private static String assignments(JsonObject values, String prefix) {
        ArrayList<String> assignments = new ArrayList<String>();
        for (String name : values.getNames()) {
            assignments.add(prefix + "`" + name + "` = $" + name);
        }
        return String.join((CharSequence)", ", assignments);
    }

    private static String conditions(List<String> fields) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (String name : fields) {
            String value;
            int colonIndex = name.indexOf(58);
            if (colonIndex != -1) {
                value = "'" + name.substring(colonIndex + 1) + "'";
                name = name.substring(0, colonIndex);
            } else {
                value = "$" + name;
            }
            conditions.add("`" + name + "` = " + value);
        }
        return String.join((CharSequence)" AND ", conditions);
    }

    public String toString() {
        return "N1qlSinkHandler{mode=" + (Object)((Object)this.mode) + ", conditions='" + this.conditions + '\'' + ", createDocuments=" + this.createDocuments + ", bucketName='" + this.bucketName + '\'' + '}';
    }
}

