/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.config.source.CouchbaseSourceTaskConfig;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.SchemaHelper;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.LookupTable;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Uncommitted
public class ConfigurableSchemaSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableSchemaSourceHandler.class);
    private LookupTable<ScopeAndCollection, Schema> valueSchemas;

    @Override
    public void init(Map<String, String> configProperties) {
        CouchbaseSourceTaskConfig config = ConfigHelper.parse(CouchbaseSourceTaskConfig.class, configProperties);
        this.valueSchemas = config.valueSchema().mapKeys(ScopeAndCollection::parse).mapValues(SchemaHelper::parseSchema);
    }

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        Schema schemaToUse = this.valueSchemas.get(ScopeAndCollection.from(params.documentEvent()));
        builder.topic(params.topic());
        builder.key(params.documentEvent().key());
        try {
            Struct record = SchemaHelper.buildStruct(schemaToUse, params.documentEvent().content());
            SchemaHelper.checkStruct(schemaToUse, record);
            builder.value(schemaToUse, record);
        }
        catch (Exception e) {
            LOGGER.debug("Document {} doesn't match specified schema. Will not be pushed to Kafka", (Object)params.documentEvent().key(), (Object)e);
            return null;
        }
        return builder;
    }
}

