/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.dcp.highlevel.Deletion;
import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.client.dcp.highlevel.Mutation;
import com.couchbase.connect.kafka.handler.source.CollectionMetadata;
import com.couchbase.connect.kafka.handler.source.MutationMetadata;
import com.couchbase.connect.kafka.util.JsonHelper;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DocumentEvent {
    private final DocumentChange change;
    private final String bucket;
    private final boolean isJson;

    public static DocumentEvent create(DocumentChange change, String bucket) {
        return new DocumentEvent(change, bucket);
    }

    private DocumentEvent(DocumentChange change, String bucket) {
        this.change = Objects.requireNonNull(change);
        this.bucket = Objects.requireNonNull(bucket);
        this.isJson = this.isMutation() ? JsonHelper.isValidJson(change.getContent()) : false;
    }

    public Map<String, String> xattrs() {
        return this.change.getXattrs();
    }

    public byte[] content() {
        return this.change.getContent();
    }

    public String bucket() {
        return this.bucket;
    }

    public short partition() {
        return (short)this.change.getVbucket();
    }

    public long partitionUuid() {
        return this.change.getOffset().getVbuuid();
    }

    public String key() {
        return this.change.getKey();
    }

    public String qualifiedKey() {
        return this.change.getQualifiedKey();
    }

    public long cas() {
        return this.change.getCas();
    }

    public long bySeqno() {
        return this.change.getOffset().getSeqno();
    }

    public long revisionSeqno() {
        return this.change.getRevision();
    }

    public boolean isMutation() {
        return this.change instanceof Mutation;
    }

    public Optional<MutationMetadata> mutationMetadata() {
        return this.isMutation() ? Optional.of(new MutationMetadata((Mutation)this.change)) : Optional.empty();
    }

    public boolean isJson() {
        return this.isJson;
    }

    public CollectionMetadata collectionMetadata() {
        return new CollectionMetadata(this.change);
    }

    public Type type() {
        if (this.change instanceof Mutation) {
            return Type.MUTATION;
        }
        if (this.change instanceof Deletion) {
            return ((Deletion)this.change).isDueToExpiration() ? Type.EXPIRATION : Type.DELETION;
        }
        return Type.UNKNOWN;
    }

    public String toString() {
        return this.change.toString();
    }

    public static enum Type {
        MUTATION,
        DELETION,
        EXPIRATION,
        UNKNOWN;

        private final String schemaName = this.name().toLowerCase(Locale.ROOT);

        public String schemaName() {
            return this.schemaName;
        }
    }
}

