/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.JsonHelper;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawJsonSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawJsonSourceHandler.class);

    protected static boolean isValidJson(byte[] bytes) {
        return JsonHelper.isValidJson(bytes);
    }

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        if (!this.passesFilter(params)) {
            return null;
        }
        if (!this.buildValue(params, builder)) {
            return null;
        }
        return builder.topic(this.getTopic(params)).key(Schema.STRING_SCHEMA, params.documentEvent().key());
    }

    protected boolean passesFilter(SourceHandlerParams params) {
        return true;
    }

    protected boolean buildValue(SourceHandlerParams params, SourceRecordBuilder builder) {
        DocumentEvent docEvent = params.documentEvent();
        DocumentEvent.Type type = docEvent.type();
        switch (type) {
            case EXPIRATION: 
            case DELETION: {
                builder.value(null, null);
                return true;
            }
            case MUTATION: {
                if (params.noValue()) {
                    builder.value(null, null);
                    return true;
                }
                byte[] document = docEvent.content();
                if (!docEvent.isJson()) {
                    LOGGER.warn("Skipping non-JSON document: bucket={} key={}", (Object)docEvent.bucket(), (Object)docEvent.qualifiedKey());
                    return false;
                }
                builder.value(null, document);
                return true;
            }
        }
        LOGGER.warn("unexpected event type {}", (Object)type);
        return false;
    }

    protected String getTopic(SourceHandlerParams params) {
        return null;
    }
}

