/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.config.source.CouchbaseSourceTaskConfig;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.SchemaHelper;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Uncommitted
public class SchemaRegistrySourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaRegistrySourceHandler.class);
    private SchemaRegistryClient schemaRegistry;
    private String missingSchemaTopic;
    private String mismatchSchemaTopic;

    @Override
    public void init(Map<String, String> configProperties) {
        this.schemaRegistry = SchemaRegistryClientFactory.newClient(Arrays.asList(configProperties.get("value.converter.schema.registry.url").split(",")), (int)10, null, configProperties, null);
        CouchbaseSourceTaskConfig config = ConfigHelper.parse(CouchbaseSourceTaskConfig.class, configProperties);
        this.missingSchemaTopic = config.missingSchemaTopic();
        this.mismatchSchemaTopic = config.schemaMismatchTopic();
    }

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        builder.topic(params.topic());
        builder.key(params.documentEvent().key());
        Schema schema = null;
        try {
            ParsedSchema parsed = (ParsedSchema)this.schemaRegistry.getSchemas(params.topic(), false, true).get(0);
            schema = SchemaHelper.parseSchema(parsed.canonicalString());
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException("Failed to retrieve schemas with the following error: ", e);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug("No schema found in Schema Registry for topic: {}", (Object)params.topic());
        }
        if (schema == null) {
            if (this.missingSchemaTopic != null && !this.missingSchemaTopic.isEmpty()) {
                LOGGER.info("No Schema found for topic: {}. Sending document with key: {} to missing schema topic: {}", new Object[]{params.topic(), params.documentEvent().key(), this.missingSchemaTopic});
                builder.topic(this.missingSchemaTopic);
                builder.value(Schema.BYTES_SCHEMA, params.documentEvent().content());
                return builder;
            }
            throw new RuntimeException("No Schema found for topic: " + params.topic() + ". \n Register a schema or set couchbase.missing.schema.topic to send documents to a missing schema topic.");
        }
        try {
            Struct record = SchemaHelper.buildStruct(schema, params.documentEvent().content());
            SchemaHelper.checkStruct(schema, record);
            builder.value(schema, record);
        }
        catch (Exception e) {
            if (this.mismatchSchemaTopic != null && !this.mismatchSchemaTopic.isEmpty()) {
                LOGGER.debug("Schema mismatch: ", (Throwable)e);
                LOGGER.info("Schema mismatch for document with key: {} Sending to mismatch topic: {}", (Object)params.documentEvent().key(), (Object)this.mismatchSchemaTopic);
                builder.topic(this.mismatchSchemaTopic);
                builder.value(Schema.BYTES_SCHEMA, params.documentEvent().content());
                return builder;
            }
            throw new RuntimeException("Schema mismatch for document with key: " + params.documentEvent().key() + ". \n Set couchbase.schema.mismatch.topic to send mismatched documents to a mismatch topic instead of throwing this error.", e);
        }
        return builder;
    }
}

