/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.transform;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.Transformation;

public class DeserializeJson<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String OVERVIEW_DOC = "Convert JSON values from a byte[] or ByteBuffer to a Map so downstream transforms can operate on the value. Any null values are passed through unmodified. The value schema is passed through unmodified (may be null).";

    public R apply(R record) {
        Object value = record.value();
        try {
            Map newValue;
            if (value == null) {
                return record;
            }
            if (value instanceof byte[]) {
                newValue = (Map)objectMapper.readValue((byte[])value, Map.class);
            } else if (value instanceof ByteBuffer) {
                try (ByteBufferInputStream in = new ByteBufferInputStream((ByteBuffer)value);){
                    newValue = (Map)objectMapper.readValue((InputStream)in, Map.class);
                }
            } else {
                throw new DataException(this.getClass().getSimpleName() + " transform expected value to be a byte array or ByteBuffer but got " + value.getClass().getName());
            }
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), (Object)newValue, record.timestamp());
        }
        catch (IOException e) {
            throw new DataException(this.getClass().getSimpleName() + " transform expected value to be JSON but got something else.", (Throwable)e);
        }
    }

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }

    static {
        objectMapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
    }
}

