/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.MDC;

public class ConnectHelper {
    private static final Pattern taskIdPattern = Pattern.compile("\\|task-(\\d+)");

    private ConnectHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Optional<String> getConnectorContextFromLoggingContext() {
        return Optional.ofNullable(MDC.get((String)"connector.context")).map(String::trim);
    }

    public static Optional<String> getTaskIdFromLoggingContext() {
        return ConnectHelper.getConnectorContextFromLoggingContext().map(context -> {
            Matcher m = taskIdPattern.matcher((CharSequence)context);
            return m.find() ? m.group(1) : null;
        });
    }
}

