/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.connect.kafka.config.sink.DurabilityConfig;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import java.util.function.Consumer;
import org.apache.kafka.connect.errors.ConnectException;

public interface DurabilitySetter
extends Consumer<CommonDurabilityOptions<?>> {
    public static DurabilitySetter create(DurabilityConfig config) {
        DurabilityLevel durabilityLevel = config.durability();
        if (durabilityLevel != DurabilityLevel.NONE) {
            if (config.persistTo() != PersistTo.NONE || config.replicateTo() != ReplicateTo.NONE) {
                String durabilityKey = ConfigHelper.keyName(DurabilityConfig.class, DurabilityConfig::durability);
                String replicateToKey = ConfigHelper.keyName(DurabilityConfig.class, DurabilityConfig::replicateTo);
                String persistToKey = ConfigHelper.keyName(DurabilityConfig.class, DurabilityConfig::persistTo);
                throw new ConnectException("Invalid durability config. When '" + durabilityKey + "' is set, you must not set '" + replicateToKey + "' or '" + persistToKey + "'.");
            }
            return options -> options.durability(durabilityLevel);
        }
        PersistTo persistTo = config.persistTo();
        ReplicateTo replicateTo = config.replicateTo();
        return options -> options.durability(persistTo, replicateTo);
    }
}

