/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import com.couchbase.connect.kafka.util.config.KafkaConfigProxyFactory;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ConfigHelper {
    private static final KafkaConfigProxyFactory factory = new KafkaConfigProxyFactory("couchbase");

    private ConfigHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ConfigDef define(Class<?> configClass) {
        return factory.define(configClass);
    }

    public static <T> T parse(Class<T> configClass, Map<String, String> props) {
        return factory.newProxy(configClass, props);
    }

    public static <T> String keyName(Class<T> configClass, Consumer<T> methodInvoker) {
        return factory.keyName(configClass, methodInvoker);
    }

    public static <T> ConfigDef.Validator validate(final SimpleValidator<T> validator, final String description) {
        return new ConfigDef.Validator(){

            public String toString() {
                return description;
            }

            public void ensureValid(String name, Object value) {
                try {
                    validator.validate(value);
                }
                catch (Exception e) {
                    throw new ConfigException(name, value, e.getMessage());
                }
            }
        };
    }

    public static interface SimpleValidator<T> {
        public void validate(T var1) throws Exception;
    }
}

