/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbStrings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Stability.Internal
public class TopologyChangeNotificationBuffer {
    private final ConcurrentMap<String, TopologyRevision> bucketNameToRevision = new ConcurrentHashMap<String, TopologyRevision>();

    public boolean putIfNewer(@Nullable String bucketName, TopologyRevision revision) {
        TopologyRevision updatedRevision = this.bucketNameToRevision.compute(TopologyChangeNotificationBuffer.key(bucketName), (k, existing) -> existing == null || revision.newerThan((TopologyRevision)existing) ? revision : existing);
        return revision == updatedRevision;
    }

    public @Nullable TopologyRevision remove(@Nullable String bucketName) {
        return (TopologyRevision)this.bucketNameToRevision.remove(TopologyChangeNotificationBuffer.key(bucketName));
    }

    private static String key(@Nullable String bucketName) {
        return CbStrings.nullToEmpty(bucketName);
    }

    public String toString() {
        return "TopologyChangeNotificationBuffer{bucketNameToRevision=" + this.bucketNameToRevision + '}';
    }
}

