/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.io.netty.kv.SaslAuthenticationHandler;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class JwtAuthenticator
implements Authenticator {
    private static final Set<SaslMechanism> supportedMechanisms = Collections.unmodifiableSet(EnumSet.of(SaslMechanism.OAUTHBEARER));
    private final Jwt jwt;
    private final String encodedJwt;
    private final String authHeaderValue;

    public static JwtAuthenticator create(String jwt) {
        return new JwtAuthenticator(jwt);
    }

    private JwtAuthenticator(String encodedJwt) {
        this.encodedJwt = encodedJwt.trim();
        this.authHeaderValue = "Bearer " + this.encodedJwt;
        this.jwt = Jwt.parse(this.encodedJwt);
    }

    @Override
    public void authKeyValueConnection(EndpointContext ctx, ChannelPipeline pipeline) {
        pipeline.addLast(new SaslAuthenticationHandler(ctx, null, this.encodedJwt, supportedMechanisms));
    }

    @Override
    public String getAuthHeaderValue() {
        return this.authHeaderValue;
    }

    public String toString() {
        return "JwtAuthenticator{jwt=" + this.jwt + '}';
    }

    private static class Jwt {
        private final ObjectNode header;
        private final ObjectNode payload;

        private Jwt(ObjectNode header, ObjectNode payload) {
            this.header = Objects.requireNonNull(header);
            this.payload = Objects.requireNonNull(payload);
        }

        public static Jwt parse(String jwt) {
            String[] parts = jwt.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Expected JWT to have 3 dot-separated components, but found " + parts.length);
            }
            List decodedParts = Arrays.stream(parts).map(Jwt::decodeBas64Url).collect(Collectors.toList());
            try {
                return new Jwt((ObjectNode)Mapper.decodeIntoTree((byte[])decodedParts.get(0)), (ObjectNode)Mapper.decodeIntoTree((byte[])decodedParts.get(1)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Malformed JWT; not JSON", e);
            }
        }

        private static byte[] decodeBas64Url(String s) {
            try {
                return Base64.getUrlDecoder().decode(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Malformed JWT; component not Base64URL-encoded", e);
            }
        }

        public String toString() {
            long expiryEpochSeconds = this.payload.path("exp").longValue();
            Duration timeUntilExpiry = Duration.ofSeconds(expiryEpochSeconds - Instant.now().getEpochSecond());
            return "Jwt{header=" + RedactableArgument.redactUser(this.header) + ", payload=" + RedactableArgument.redactUser(this.payload) + ", signature=<redacted>, timeUntilExpiry=" + timeUntilExpiry + '}';
        }
    }
}

