/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel.internal;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class SimpleThreadFactory
implements ThreadFactory {
    private final AtomicInteger nextId = new AtomicInteger();
    private final String baseName;
    private final Consumer<Thread> customizer;

    public SimpleThreadFactory(String baseName, Consumer<Thread> customizer) {
        this.baseName = Objects.requireNonNull(baseName);
        this.customizer = Objects.requireNonNull(customizer);
    }

    @Override
    public Thread newThread(Runnable r) {
        Objects.requireNonNull(r);
        Thread t = new Thread(r);
        t.setName(this.baseName + this.nextId.getAndIncrement());
        this.customizer.accept(t);
        return t;
    }
}

