/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.Objects;

@Stability.Internal
public class TopologyRevision
implements Comparable<TopologyRevision> {
    public static final TopologyRevision ZERO = new TopologyRevision(0L, 0L);
    private static final Comparator<TopologyRevision> comparator = Comparator.comparing(TopologyRevision::epoch).thenComparing(TopologyRevision::rev);
    private final long epoch;
    private final long rev;

    public static TopologyRevision parse(ObjectNode json) {
        long epoch = json.path("revEpoch").longValue();
        JsonNode revNode = json.path("rev");
        if (!revNode.isIntegralNumber()) {
            throw new IllegalArgumentException("Missing or non-integer 'rev' field.");
        }
        return new TopologyRevision(epoch, revNode.longValue());
    }

    public TopologyRevision(long epoch, long rev) {
        if (rev < 0L) {
            throw new IllegalArgumentException("Config revision must be non-negative, but got " + rev);
        }
        this.epoch = epoch;
        this.rev = rev;
    }

    public long epoch() {
        return this.epoch;
    }

    public long rev() {
        return this.rev;
    }

    @Override
    public int compareTo(TopologyRevision o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyRevision that = (TopologyRevision)o;
        return this.epoch == that.epoch && this.rev == that.rev;
    }

    public String toString() {
        return this.epoch + "." + this.rev;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.rev);
    }

    public boolean newerThan(TopologyRevision other) {
        return this.compareTo(other) > 0;
    }
}

