/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.CoreSearchOptions;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.ConnectionStringPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.DelegatingAuthenticator;
import com.couchbase.client.core.env.OwnedOrExternal;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.context.ReducedSearchErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ClusterCleanupTask;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Jdk8Cleaner;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.DiagnosticsOptions;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.http.AsyncCouchbaseHttpClient;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.java.manager.bucket.AsyncBucketManager;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.java.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.java.manager.user.AsyncUserManager;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.SearchRequest;
import com.couchbase.client.java.search.result.SearchResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AsyncCluster {
    private final OwnedOrExternal<ClusterEnvironment> environment;
    private final CoreCouchbaseOps couchbaseOps;
    private final DelegatingAuthenticator authenticator;
    private final Map<String, AsyncBucket> bucketCache = new ConcurrentHashMap<String, AsyncBucket>();
    final CoreQueryOps queryOps;
    final CoreSearchOps searchOps;
    final ConnectionString connectionString;
    private final AtomicBoolean disconnected = new AtomicBoolean();

    public static AsyncCluster connect(String connectionString, String username, String password) {
        return AsyncCluster.connect(connectionString, ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password)));
    }

    public static AsyncCluster connect(String connectionString, ClusterOptions options) {
        Validators.notNullOrEmpty((String)connectionString, (String)"ConnectionString");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        ConnectionString connStr = ConnectionString.create((String)connectionString);
        OwnedOrExternal<ClusterEnvironment> environment = AsyncCluster.extractClusterEnvironment(connStr, opts);
        return new AsyncCluster(environment, opts.authenticator(), connStr);
    }

    public static AsyncCluster connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster.connect(ConnectionStringUtil.asConnectionString(seedNodes).original(), options);
    }

    static OwnedOrExternal<ClusterEnvironment> extractClusterEnvironment(ConnectionString connectionString, ClusterOptions.Built opts) {
        OwnedOrExternal env;
        if (opts.environment() == null) {
            ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
            if (opts.environmentCustomizer() != null) {
                opts.environmentCustomizer().accept(builder);
            }
            builder.load((PropertyLoader)new ConnectionStringPropertyLoader(connectionString));
            builder.loadSystemProperties();
            env = OwnedOrExternal.owned((Object)((Object)builder.build()));
        } else {
            env = OwnedOrExternal.external((Object)((Object)opts.environment()));
        }
        ConnectionStringUtil.checkConnectionString((CoreEnvironment)((CoreEnvironment)env.get()), (boolean)env.isOwned(), (ConnectionString)connectionString);
        return env;
    }

    String clusterToStringHelper(Class clusterClass) {
        String json = ((ClusterEnvironment)((Object)this.environment.get())).exportAsString(Context.ExportFormat.JSON);
        ObjectNode jsonObject = (ObjectNode)Mapper.decodeIntoTree((String)json);
        jsonObject.put("connectionString", this.connectionString.original());
        return clusterClass.getSimpleName() + jsonObject;
    }

    AsyncCluster(OwnedOrExternal<ClusterEnvironment> environment, Authenticator initialAuthenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.connectionString = connectionString;
        this.authenticator = DelegatingAuthenticator.create((boolean)((ClusterEnvironment)((Object)environment.get())).securityConfig().tlsEnabled(), (Authenticator)initialAuthenticator);
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)((CoreEnvironment)environment.get()), (Authenticator)this.authenticator, (ConnectionString)connectionString);
        this.queryOps = this.couchbaseOps.queryOps();
        this.searchOps = this.couchbaseOps.searchOps(null);
        if (this.couchbaseOps instanceof Core) {
            ((Core)this.couchbaseOps).initGlobalConfig();
        }
        Duration autoDisconnectTimeout = this.environment().timeoutConfig().disconnectTimeout().plus(Duration.ofSeconds(15L));
        Jdk8Cleaner.registerWithOneShotCleaner((Object)this, (Runnable)new ClusterCleanupTask(this.disconnectInternal(autoDisconnectTimeout), this.environment().eventBus(), this.disconnected));
    }

    public void authenticator(Authenticator newAuthenticator) {
        this.authenticator.setDelegate(newAuthenticator);
    }

    public ClusterEnvironment environment() {
        return (ClusterEnvironment)((Object)this.environment.get());
    }

    @Stability.Volatile
    public Core core() {
        return this.couchbaseOps.asCore();
    }

    @Stability.Internal
    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    @Stability.Volatile
    public AsyncCouchbaseHttpClient httpClient() {
        return new AsyncCouchbaseHttpClient(this);
    }

    public AsyncUserManager users() {
        return new AsyncUserManager(this.core(), this);
    }

    public AsyncBucketManager buckets() {
        return new AsyncBucketManager(this.couchbaseOps, this);
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return new AsyncAnalyticsIndexManager(this);
    }

    public AsyncQueryIndexManager queryIndexes() {
        return new AsyncQueryIndexManager(this.couchbaseOps().queryOps(), this.couchbaseOps().coreResources().requestTracer(), this);
    }

    public AsyncSearchIndexManager searchIndexes() {
        return new AsyncSearchIndexManager(this.couchbaseOps, this);
    }

    @Stability.Uncommitted
    public AsyncEventingFunctionManager eventingFunctions() {
        return new AsyncEventingFunctionManager(this.core(), this, null);
    }

    public CompletableFuture<QueryResult> query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public CompletableFuture<QueryResult> query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? ((ClusterEnvironment)((Object)this.environment.get())).jsonSerializer() : opts.serializer();
        return this.queryOps.queryAsync(statement, (CoreQueryOptions)opts, null, null, QueryAccessor::convertCoreQueryError).thenApply(r -> new QueryResult((CoreQueryResult)r, serializer));
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? ((ClusterEnvironment)((Object)this.environment.get())).jsonSerializer() : opts.serializer();
        return AnalyticsAccessor.analyticsQueryAsync(this.core(), this.analyticsRequest(statement, opts), serializer);
    }

    AnalyticsRequest analyticsRequest(String statement, AnalyticsOptions.Built opts) {
        Validators.notNullOrEmpty((String)statement, (String)"Statement", () -> new ReducedAnalyticsErrorContext(statement));
        Duration timeout = opts.timeout().orElse(((ClusterEnvironment)((Object)this.environment.get())).timeoutConfig().analyticsTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(((ClusterEnvironment)((Object)this.environment.get())).retryStrategy());
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((Duration)timeout));
        opts.injectParams(query);
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        String clientContextId = query.getString("client_context_id");
        RequestSpan span = this.couchbaseOps().coreResources().requestTracer().requestSpan("analytics", (RequestSpan)opts.parentSpan().orElse(null));
        AnalyticsRequest request = new AnalyticsRequest(timeout, this.core().context(), retryStrategy, (Authenticator)this.authenticator, queryBytes, opts.priority(), opts.readonly(), clientContextId, statement, span, null, null);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<SearchResult> search(String indexName, SearchRequest searchRequest) {
        return this.search(indexName, searchRequest, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public CompletableFuture<SearchResult> search(String indexName, SearchRequest searchRequest, SearchOptions options) {
        Validators.notNull((Object)searchRequest, (String)"SearchRequest", () -> new ReducedSearchErrorContext(indexName, null));
        Validators.notNull((Object)options, (String)"SearchOptions", () -> new ReducedSearchErrorContext(indexName, null));
        CoreSearchRequest coreRequest = searchRequest.toCore();
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? ((ClusterEnvironment)((Object)this.environment.get())).jsonSerializer() : opts.serializer();
        return this.searchOps.searchAsync(indexName, coreRequest, (CoreSearchOptions)opts).thenApply(r -> new SearchResult((CoreSearchResult)r, serializer));
    }

    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Validators.notNull((Object)query, (String)"SearchQuery", () -> new ReducedSearchErrorContext(indexName, null));
        CoreSearchQuery coreQuery = query.toCore();
        Validators.notNull((Object)options, (String)"SearchOptions", () -> new ReducedSearchErrorContext(indexName, coreQuery));
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? ((ClusterEnvironment)((Object)this.environment.get())).jsonSerializer() : opts.serializer();
        return this.searchOps.searchQueryAsync(indexName, coreQuery, (CoreSearchOptions)opts).thenApply(r -> new SearchResult((CoreSearchResult)r, serializer));
    }

    public AsyncBucket bucket(String bucketName) {
        Validators.notNullOrEmpty((String)bucketName, (String)"Name");
        return this.bucketCache.computeIfAbsent(bucketName, n -> {
            if (this.couchbaseOps instanceof Core) {
                ((Core)this.couchbaseOps).openBucket(n);
            }
            return new AsyncBucket((String)n, this.couchbaseOps, (ClusterEnvironment)((Object)((Object)this.environment.get())), this);
        });
    }

    public CompletableFuture<Void> disconnect() {
        return this.disconnect(((ClusterEnvironment)((Object)this.environment.get())).timeoutConfig().disconnectTimeout());
    }

    public CompletableFuture<Void> disconnect(Duration timeout) {
        return this.disconnectInternal(timeout).toFuture();
    }

    Mono<Void> disconnectInternal(Duration timeout) {
        return AsyncCluster.disconnectInternal(this.disconnected, timeout, this.couchbaseOps, (CoreEnvironment)this.environment.get(), this.environment.isOwned());
    }

    static Mono<Void> disconnectInternal(AtomicBoolean disconnected, Duration timeout, CoreCouchbaseOps couchbaseOps, CoreEnvironment environment, boolean ownsEnvironment) {
        return couchbaseOps.shutdown(timeout).then(ownsEnvironment ? environment.shutdownReactive(timeout) : Mono.empty()).then(Mono.fromRunnable(() -> disconnected.set(true)));
    }

    public CompletableFuture<DiagnosticsResult> diagnostics() {
        return this.diagnostics(ReactiveCluster.DEFAULT_DIAGNOSTICS_OPTIONS);
    }

    public CompletableFuture<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        Validators.notNull((Object)options, (String)"DiagnosticsOptions");
        DiagnosticsOptions.Built opts = options.build();
        return Mono.defer(() -> Mono.just((Object)new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(EndpointDiagnostics::type)), this.core().context().environment().userAgent().formattedShort(), opts.reportId().orElse(UUID.randomUUID().toString())))).toFuture();
    }

    public CompletableFuture<PingResult> ping() {
        return this.ping(ReactiveCluster.DEFAULT_PING_OPTIONS);
    }

    public CompletableFuture<PingResult> ping(PingOptions options) {
        Validators.notNull((Object)options, (String)"PingOptions");
        PingOptions.Built opts = options.build();
        return HealthPinger.ping((Core)this.core(), opts.timeout(), (RetryStrategy)opts.retryStrategy().orElse(((ClusterEnvironment)((Object)this.environment.get())).retryStrategy()), opts.serviceTypes(), opts.reportId(), Optional.empty()).toFuture();
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, ReactiveCluster.DEFAULT_WAIT_UNTIL_READY_OPTIONS);
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        Validators.notNull((Object)options, (String)"WaitUntilReadyOptions");
        WaitUntilReadyOptions.Built opts = options.build();
        return this.couchbaseOps.waitUntilReady(opts.serviceTypes(), timeout, opts.desiredState(), null);
    }

    public String toString() {
        return this.clusterToStringHelper(this.getClass());
    }
}

