/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.manager.collection.ReactiveCollectionManager;
import com.couchbase.client.java.manager.view.ReactiveViewIndexManager;
import com.couchbase.client.java.view.ReactiveViewResult;
import com.couchbase.client.java.view.ViewAccessor;
import com.couchbase.client.java.view.ViewOptions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;

public class ReactiveBucket {
    static final ViewOptions DEFAULT_VIEW_OPTIONS = ViewOptions.viewOptions();
    private final AsyncBucket asyncBucket;
    private final Map<String, ReactiveScope> scopeCache = new ConcurrentHashMap<String, ReactiveScope>();

    ReactiveBucket(AsyncBucket asyncBucket) {
        this.asyncBucket = asyncBucket;
    }

    public AsyncBucket async() {
        return this.asyncBucket;
    }

    public String name() {
        return this.asyncBucket.name();
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncBucket.core();
    }

    public ReactiveCollectionManager collections() {
        return new ReactiveCollectionManager((ReactorOps)this.environment(), this.asyncBucket.collections());
    }

    @Deprecated
    public ReactiveViewIndexManager viewIndexes() {
        return new ReactiveViewIndexManager((ReactorOps)this.environment(), this.asyncBucket.viewIndexes());
    }

    public ClusterEnvironment environment() {
        return this.asyncBucket.environment();
    }

    public ReactiveScope scope(String name) {
        return this.scopeCache.computeIfAbsent(name, n -> new ReactiveScope(this.asyncBucket.scope((String)n)));
    }

    public ReactiveScope defaultScope() {
        return this.scopeCache.computeIfAbsent("_default", n -> new ReactiveScope(this.asyncBucket.defaultScope()));
    }

    public ReactiveCollection defaultCollection() {
        return this.defaultScope().defaultCollection();
    }

    public ReactiveCollection collection(String collectionName) {
        return this.defaultScope().collection(collectionName);
    }

    @Deprecated
    public Mono<ReactiveViewResult> viewQuery(String designDoc, String viewName) {
        return this.viewQuery(designDoc, viewName, DEFAULT_VIEW_OPTIONS);
    }

    @Deprecated
    public Mono<ReactiveViewResult> viewQuery(String designDoc, String viewName, ViewOptions options) {
        return Mono.defer(() -> {
            Validators.notNull((Object)options, (String)"ViewOptions", () -> new ReducedViewErrorContext(designDoc, viewName, this.name()));
            ViewOptions.Built opts = options.build();
            JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
            return ViewAccessor.viewQueryReactive(this.asyncBucket.core(), this.asyncBucket.viewRequest(designDoc, viewName, opts), serializer);
        });
    }

    public Mono<PingResult> ping() {
        return this.ping(ReactiveCluster.DEFAULT_PING_OPTIONS);
    }

    public Mono<PingResult> ping(PingOptions options) {
        return Mono.defer(() -> Mono.fromFuture(this.asyncBucket.ping(options)));
    }

    public Mono<Void> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, ReactiveCluster.DEFAULT_WAIT_UNTIL_READY_OPTIONS);
    }

    public Mono<Void> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return Mono.defer(() -> Mono.fromFuture(this.asyncBucket.waitUntilReady(timeout, options)));
    }
}

