/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreViewIndexManager;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.DropDesignDocumentOptions;
import com.couchbase.client.java.manager.view.GetAllDesignDocumentsOptions;
import com.couchbase.client.java.manager.view.GetDesignDocumentOptions;
import com.couchbase.client.java.manager.view.PublishDesignDocumentOptions;
import com.couchbase.client.java.manager.view.UpsertDesignDocumentOptions;
import com.couchbase.client.java.manager.view.View;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AsyncViewIndexManager {
    private final CoreViewIndexManager coreManager;
    private final String bucket;
    private final AsyncCluster cluster;

    public AsyncViewIndexManager(Core core, String bucket, AsyncCluster cluster) {
        this.coreManager = new CoreViewIndexManager(core, bucket);
        this.bucket = Objects.requireNonNull(bucket);
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace) {
        return this.getAllDesignDocuments(namespace, GetAllDesignDocumentsOptions.getAllDesignDocumentsOptions());
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace, GetAllDesignDocumentsOptions options) {
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)options, (String)"GetAllDesignDocumentsOptions", () -> new ReducedViewErrorContext(null, null, this.bucket));
        return this.coreManager.getAllDesignDocuments(namespace == DesignDocumentNamespace.PRODUCTION, (CoreCommonOptions)options.build()).thenApply(AsyncViewIndexManager::parseAllDesignDocuments);
    }

    private static List<DesignDocument> parseAllDesignDocuments(Map<String, ObjectNode> ddocNameToJson) {
        ArrayList<DesignDocument> result = new ArrayList<DesignDocument>();
        ddocNameToJson.forEach((k, v) -> result.add(AsyncViewIndexManager.parseDesignDocument(k, (JsonNode)v)));
        return result;
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.getDesignDocument(name, namespace, GetDesignDocumentOptions.getDesignDocumentOptions());
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace, GetDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull((Object)options, (String)"GetDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.getDesignDocument(name, namespace == DesignDocumentNamespace.PRODUCTION, (CoreCommonOptions)options.build()).thenApply(responseBytes -> AsyncViewIndexManager.parseDesignDocument(name, Mapper.decodeIntoTree((byte[])responseBytes)));
    }

    private static DesignDocument parseDesignDocument(String name, JsonNode node) {
        ObjectNode viewsNode = (ObjectNode)node.path("views");
        Map views = (Map)Mapper.convertValue((Object)viewsNode, (TypeReference)new TypeReference<Map<String, View>>(){});
        return new DesignDocument(CbStrings.removeStart((String)name, (String)"dev_"), views);
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace) {
        return this.upsertDesignDocument(doc, namespace, UpsertDesignDocumentOptions.upsertDesignDocumentOptions());
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace, UpsertDesignDocumentOptions options) {
        Validators.notNull((Object)doc, (String)"DesignDocument", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        Validators.notNull((Object)options, (String)"UpsertDesignDocumentOptions", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        byte[] docBytes = Mapper.encodeAsBytes((Object)AsyncViewIndexManager.toJson(doc));
        return this.coreManager.upsertDesignDocument(doc.name(), docBytes, namespace == DesignDocumentNamespace.PRODUCTION, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> publishDesignDocument(String name) {
        return this.publishDesignDocument(name, PublishDesignDocumentOptions.publishDesignDocumentOptions());
    }

    public CompletableFuture<Void> publishDesignDocument(String name, PublishDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)options, (String)"PublishDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.publishDesignDocument(name, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.dropDesignDocument(name, namespace, DropDesignDocumentOptions.dropDesignDocumentOptions());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace, DropDesignDocumentOptions options) {
        Validators.notNullOrEmpty((String)name, (String)"Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull((Object)((Object)namespace), (String)"DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull((Object)options, (String)"DropDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.dropDesignDocument(name, namespace == DesignDocumentNamespace.PRODUCTION, (CoreCommonOptions)options.build());
    }

    private static ObjectNode toJson(DesignDocument doc) {
        ObjectNode root = Mapper.createObjectNode();
        ObjectNode views = root.putObject("views");
        doc.views().forEach((k, v) -> {
            ObjectNode viewNode = Mapper.createObjectNode();
            viewNode.put("map", v.map());
            v.reduce().ifPresent(r -> viewNode.put("reduce", r));
            views.set(k, (JsonNode)viewNode);
        });
        return root;
    }
}

