/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp;

import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContextBuilder;
import com.couchbase.client.dcp.Authenticator;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;

public class CertificateAuthenticator
implements Authenticator {
    private final PrivateKey key;
    private final String keyPassword;
    private final List<X509Certificate> keyCertChain;
    private final Supplier<KeyManagerFactory> keyManagerFactory;

    public static CertificateAuthenticator fromKeyStore(Path keyStorePath, String keyStorePassword) {
        return CertificateAuthenticator.fromKeyStore(keyStorePath, keyStorePassword, null);
    }

    public static CertificateAuthenticator fromKeyStore(Path keyStorePath, String keyStorePassword, String keyStoreType) {
        CertificateAuthenticator certificateAuthenticator;
        block8: {
            Objects.requireNonNull(keyStorePath, "KeyStorePath");
            InputStream keyStoreInputStream = Files.newInputStream(keyStorePath, new OpenOption[0]);
            try {
                KeyStore store = KeyStore.getInstance(keyStoreType != null ? keyStoreType : KeyStore.getDefaultType());
                store.load(keyStoreInputStream, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
                certificateAuthenticator = CertificateAuthenticator.fromKeyStore(store, keyStorePassword);
                if (keyStoreInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keyStoreInputStream != null) {
                        try {
                            keyStoreInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Could not initialize KeyStore from Path", ex);
                }
            }
            keyStoreInputStream.close();
        }
        return certificateAuthenticator;
    }

    public static CertificateAuthenticator fromKeyStore(KeyStore keyStore, String keyStorePassword) {
        Objects.requireNonNull(keyStore, "KeyStore");
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
            return CertificateAuthenticator.fromKeyManagerFactory(() -> kmf);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not initialize KeyManagerFactory with KeyStore", ex);
        }
    }

    public static CertificateAuthenticator fromKeyManagerFactory(Supplier<KeyManagerFactory> keyManagerFactory) {
        Objects.requireNonNull(keyManagerFactory, "KeyManagerFactory");
        return new CertificateAuthenticator(null, null, null, keyManagerFactory);
    }

    public static CertificateAuthenticator fromKey(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain) {
        Objects.requireNonNull(key, "PrivateKey");
        if (CbCollections.isNullOrEmpty(keyCertChain)) {
            throw new IllegalArgumentException("KeyCertChain must not be null or empty");
        }
        return new CertificateAuthenticator(key, keyPassword, keyCertChain, null);
    }

    private CertificateAuthenticator(PrivateKey key, String keyPassword, List<X509Certificate> keyCertChain, Supplier<KeyManagerFactory> keyManagerFactory) {
        this.key = key;
        this.keyPassword = keyPassword;
        this.keyCertChain = keyCertChain;
        this.keyManagerFactory = keyManagerFactory;
        if (key != null && keyManagerFactory != null) {
            throw new IllegalArgumentException("Either a key certificate or a key manager factory can be provided, but not both!");
        }
    }

    @Override
    public void applyTlsProperties(SslContextBuilder context) {
        if (this.keyManagerFactory != null) {
            context.keyManager(this.keyManagerFactory.get());
        } else if (this.key != null) {
            context.keyManager(this.key, this.keyPassword, this.keyCertChain.toArray(new X509Certificate[0]));
        }
    }

    @Override
    public boolean requiresTls() {
        return true;
    }

    public String toString() {
        return "CertificateAuthenticator{hasKey=" + (this.key != null) + ", hasKeyManagerFactory=" + (this.keyManagerFactory != null) + '}';
    }
}

