/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.utils;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.json.JsonMapper;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class JacksonHelper {
    private static final JsonMapper mapper = new JsonMapper();

    public static ObjectNode readObject(byte[] json) {
        try {
            return (ObjectNode)mapper.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a JSON object but got something else", e);
        }
    }

    public static ObjectNode readObject(String json) {
        try {
            return (ObjectNode)mapper.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a JSON object but got something else", e);
        }
    }

    public static <T> T convertValue(Object from, TypeReference<T> toValueTypeRef) {
        return (T)mapper.convertValue(from, toValueTypeRef);
    }

    public static ObjectReader reader() {
        return mapper.reader();
    }

    public static <T> List<T> transform(ArrayNode array, Function<JsonNode, ? extends T> transformer) {
        ArrayList result = new ArrayList();
        array.forEach(elementNode -> result.add(transformer.apply((JsonNode)elementNode)));
        return result;
    }
}

