/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.message.DcpSystemEvent;
import com.couchbase.client.dcp.message.MessageUtil;

public class CollectionDropped
extends DcpSystemEvent
implements DcpSystemEvent.CollectionsManifestEvent,
DatabaseChangeEvent {
    private final long newManifestId;
    private final long collectionId;
    private final long scopeId;

    public CollectionDropped(int vbucket, long seqno, int version, ByteBuf buffer) {
        super(DcpSystemEvent.Type.COLLECTION_DROPPED, vbucket, seqno, version);
        ByteBuf value = MessageUtil.getContent(buffer);
        this.newManifestId = value.readLong();
        this.scopeId = value.readUnsignedInt();
        this.collectionId = value.readUnsignedInt();
    }

    @Override
    public long getManifestId() {
        return this.newManifestId;
    }

    public long getScopeId() {
        return this.scopeId;
    }

    public long getCollectionId() {
        return this.collectionId;
    }

    @Override
    public CollectionsManifest apply(CollectionsManifest currentManifest) {
        return currentManifest.withoutCollection(this.newManifestId, this.collectionId);
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onCollectionDropped(this);
    }

    public String toString() {
        return "CollectionDropped{newManifestId=" + this.newManifestId + ", collectionId=" + this.collectionId + ", scopeId=" + this.scopeId + ", vbucket=" + this.getVbucket() + ", seqno=" + this.getSeqno() + ", version=" + this.getVersion() + '}';
    }
}

