/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;

public class UserAgentBuilder {
    private final List<String> parts = new ArrayList<String>();

    public UserAgentBuilder append(String productName, String productVersion, String ... comments) {
        if (productName.isEmpty()) {
            throw new IllegalArgumentException("Product name must not be empty.");
        }
        StringBuilder part = new StringBuilder(UserAgentBuilder.sanitizeToken(productName));
        if (productVersion != null && !productVersion.isEmpty()) {
            part.append('/').append(UserAgentBuilder.sanitizeToken(productVersion));
        }
        ArrayList<String> escapedComments = new ArrayList<String>();
        for (String comment : comments) {
            escapedComments.add(UserAgentBuilder.escapeComment(UserAgentBuilder.sanitizeComment(comment)));
        }
        if (!escapedComments.isEmpty()) {
            part.append(" (").append(String.join((CharSequence)"; ", escapedComments)).append(")");
        }
        this.parts.add(part.toString());
        return this;
    }

    public UserAgentBuilder appendJava() {
        return this.append("Java", System.getProperty("java.version"), UserAgentBuilder.systemProperties("java.vendor", "java.vm.name", "java.vm.version"));
    }

    public UserAgentBuilder appendOs() {
        return this.append("OS", null, UserAgentBuilder.systemProperties("os.name", "os.version", "os.arch"));
    }

    private static String[] systemProperties(String ... names) {
        return (String[])Arrays.stream(names).map(System::getProperty).toArray(String[]::new);
    }

    public String build() {
        return String.join((CharSequence)" ", this.parts);
    }

    public String toString() {
        return this.build();
    }

    private static String sanitizeComment(String comment) {
        return UserAgentBuilder.sanitize(comment, UserAgentBuilder::isCommentChar, '?');
    }

    private static String sanitizeToken(String token) {
        return UserAgentBuilder.sanitize(token, UserAgentBuilder::isTokenChar, '_');
    }

    private static String sanitize(String s, IntPredicate validChar, char invalidCharReplacement) {
        if (s.chars().allMatch(validChar)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        s.chars().forEach(c -> sb.append(validChar.test(c) ? (char)c : invalidCharReplacement));
        return sb.toString();
    }

    private static boolean isTokenChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || "!#$%&'*+-.^_`|~".indexOf(c) != -1;
    }

    private static boolean isCommentChar(int c) {
        return c >= 32 && c <= 126 || c == 9;
    }

    private static String escapeComment(String comment) {
        return comment.replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)");
    }
}

