/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka;

import com.couchbase.client.core.env.CouchbaseThreadFactory;
import com.couchbase.client.core.logging.LogRedaction;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.NanoTimestamp;
import com.couchbase.client.dcp.core.logging.RedactionLevel;
import com.couchbase.client.dcp.highlevel.DocumentChange;
import com.couchbase.client.dcp.util.PartitionSet;
import com.couchbase.connect.kafka.CouchbaseReader;
import com.couchbase.connect.kafka.SourceDocumentLifecycle;
import com.couchbase.connect.kafka.SourceOffset;
import com.couchbase.connect.kafka.SourceTaskLifecycle;
import com.couchbase.connect.kafka.config.common.LoggingConfig;
import com.couchbase.connect.kafka.config.source.CouchbaseSourceTaskConfig;
import com.couchbase.connect.kafka.config.source.SourceBehaviorConfig;
import com.couchbase.connect.kafka.filter.Filter;
import com.couchbase.connect.kafka.handler.source.CollectionMetadata;
import com.couchbase.connect.kafka.handler.source.CouchbaseHeaderSetter;
import com.couchbase.connect.kafka.handler.source.CouchbaseSourceRecord;
import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.MultiSourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.couchbase.connect.kafka.util.ConnectHelper;
import com.couchbase.connect.kafka.util.FirstCallTracker;
import com.couchbase.connect.kafka.util.JmxHelper;
import com.couchbase.connect.kafka.util.ScopeAndCollection;
import com.couchbase.connect.kafka.util.TopicMap;
import com.couchbase.connect.kafka.util.Version;
import com.couchbase.connect.kafka.util.Watchdog;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import com.couchbase.connect.kafka.util.config.LookupTable;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import io.micrometer.jmx.JmxMeterRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseSourceTask
extends SourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseSourceTask.class);
    private static final long STOP_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final ThreadFactory cleanupThreadFactory = new CouchbaseThreadFactory("cb-source-task-cleanup-");
    private String connectorName;
    private volatile CouchbaseReader couchbaseReader;
    private BlockingQueue<DocumentChange> queue;
    private BlockingQueue<Throwable> errorQueue;
    private LookupTable<ScopeAndCollection, String> topicTemplate;
    private String bucket;
    private Filter filter;
    private LookupTable<ScopeAndCollection, JsonPath> jsonPaths;
    private static final JsonPath ROOT_JSON_PATH = JsonPath.compile((String)"$", (Predicate[])new Predicate[0]);
    private static final Configuration jsonpathConf = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.AS_PATH_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
    private MultiSourceHandler sourceHandler;
    private CouchbaseHeaderSetter headerSetter;
    private int batchSizeMax;
    private boolean connectorNameInOffsets;
    private boolean noValue;
    private SourceDocumentLifecycle lifecycle;
    private volatile MeterRegistry meterRegistry;
    private Counter filteredCounter;
    private Timer handlerTimer;
    private Timer filterTimer;
    private Timer timeBetweenPollsTimer;
    private NanoTimestamp endOfLastPoll;
    private final CountDownLatch startupComplete = new CountDownLatch(1);
    private Optional<String> blackHoleTopic;
    private Optional<String> initialOffsetTopic;
    private final SourceTaskLifecycle taskLifecycle = new SourceTaskLifecycle();
    private final Watchdog watchdog = new Watchdog(this.taskLifecycle.taskUuid());
    private final FirstCallTracker start = new FirstCallTracker();
    private final FirstCallTracker cleanup = new FirstCallTracker();

    public static JsonPath parseJsonpath(String s) {
        return s.isEmpty() || s.equals("$") ? ROOT_JSON_PATH : JsonPath.compile((String)s, (Predicate[])new Predicate[0]);
    }

    private String taskUuid() {
        return this.taskLifecycle.taskUuid();
    }

    public String version() {
        return Version.getVersion();
    }

    public void initialize(SourceTaskContext context) {
        super.initialize(context);
        this.taskLifecycle.logTaskInitialized((String)context.configs().get("name"));
    }

    public void commit() throws InterruptedException {
        super.commit();
        this.taskLifecycle.logOffsetCommitHook();
    }

    public void start(Map<String, String> properties) {
        if (this.start.alreadyCalled()) {
            throw new IllegalStateException("This source task's start() method has already been called; this violates an important assumption about how the Kafka Connect framework manages the SourceTask lifecycle. taskUuid=" + this.taskUuid());
        }
        try {
            CouchbaseSourceTaskConfig config;
            this.watchdog.start();
            this.connectorName = properties.get("name");
            try {
                config = ConfigHelper.parse(CouchbaseSourceTaskConfig.class, properties);
                if (CbStrings.isNullOrEmpty((String)this.connectorName)) {
                    throw new ConfigException("Connector must have a non-blank 'name' config property.");
                }
            }
            catch (ConfigException e) {
                throw new ConnectException("Couldn't start CouchbaseSourceTask due to configuration error", (Throwable)e);
            }
            String taskNumber = ConnectHelper.getTaskIdFromLoggingContext().orElse(config.maybeTaskId());
            String clusterUuid = config.clusterUuid();
            String bucketName = config.bucket();
            this.meterRegistry = CouchbaseSourceTask.newMeterRegistry(this.connectorName, taskNumber, config);
            this.meterRegistry.config().commonTags(new String[]{"bucket", bucketName, "clusterUuid", clusterUuid});
            this.handlerTimer = this.meterRegistry.timer("handler", new String[0]);
            this.filterTimer = this.meterRegistry.timer("filter", new String[0]);
            this.filteredCounter = this.meterRegistry.counter("filtered.out", new String[0]);
            this.timeBetweenPollsTimer = this.meterRegistry.timer("time.between.polls", new String[0]);
            LogRedaction.setRedactionLevel((com.couchbase.client.core.logging.RedactionLevel)config.logRedaction());
            RedactionLevel.set((RedactionLevel)this.toDcp(config.logRedaction()));
            Map<String, String> unmodifiableProperties = Collections.unmodifiableMap(properties);
            this.lifecycle = SourceDocumentLifecycle.create(this.taskUuid(), config);
            this.jsonPaths = config.jsonpathFilter().mapKeys(ScopeAndCollection::parse).mapValues(CouchbaseSourceTask::parseJsonpath);
            this.filter = (Filter)Utils.newInstance(config.eventFilter());
            this.filter.init(unmodifiableProperties);
            this.sourceHandler = CouchbaseSourceTask.createSourceHandler(config);
            this.sourceHandler.init(unmodifiableProperties);
            this.headerSetter = new CouchbaseHeaderSetter(config.headerNamePrefix(), config.headers());
            this.blackHoleTopic = Optional.ofNullable(CbStrings.emptyToNull((String)config.blackHoleTopic().trim()));
            this.initialOffsetTopic = Optional.ofNullable(CbStrings.emptyToNull((String)config.initialOffsetTopic().trim()));
            this.topicTemplate = config.topic().mapKeys(ScopeAndCollection::parse).withUnderlay(TopicMap.parseCollectionToTopic(config.collectionToTopic()));
            this.bucket = config.bucket();
            this.connectorNameInOffsets = config.connectorNameInOffsets();
            this.batchSizeMax = config.batchSizeMax();
            this.noValue = config.noValue();
            PartitionSet partitionSet = PartitionSet.parse((String)config.partitions());
            this.taskLifecycle.logTaskStarted(this.connectorName, partitionSet);
            List partitions = partitionSet.toList();
            Map<Integer, SourceOffset> partitionToSavedSeqno = this.readSourceOffsets(partitions);
            HashSet partitionsWithoutSavedOffsets = new HashSet(partitions);
            partitionsWithoutSavedOffsets.removeAll(partitionToSavedSeqno.keySet());
            this.taskLifecycle.logSourceOffsetsRead(partitionToSavedSeqno, PartitionSet.from(partitionsWithoutSavedOffsets));
            this.queue = new LinkedBlockingQueue<DocumentChange>();
            this.errorQueue = new LinkedBlockingQueue<Throwable>(1);
            this.couchbaseReader = new CouchbaseReader(config, this.connectorName, taskNumber, this.queue, this.errorQueue, partitions, partitionToSavedSeqno, this.lifecycle, this.meterRegistry, this.initialOffsetTopic.isPresent(), this.taskLifecycle);
            this.couchbaseReader.start();
            this.endOfLastPoll = NanoTimestamp.now();
            this.watchdog.enterState("started");
        }
        catch (Exception e) {
            LOGGER.info("Scheduling cleanup because task failed to start. taskUuid={}", (Object)this.taskUuid(), (Object)e);
            this.startupComplete.countDown();
            this.cleanup();
            throw e;
        }
        finally {
            this.startupComplete.countDown();
        }
    }

    private static MeterRegistry newMeterRegistry(String connectorName, String taskId, CouchbaseSourceTaskConfig config) {
        LinkedHashMap<String, String> commonKeyProperties = new LinkedHashMap<String, String>();
        commonKeyProperties.put("connector", ObjectName.quote(connectorName));
        commonKeyProperties.put("task", taskId);
        JmxMeterRegistry jmx = JmxHelper.newJmxMeterRegistry("kafka.connect.couchbase", commonKeyProperties);
        CompositeMeterRegistry composite = new CompositeMeterRegistry();
        composite.add((MeterRegistry)jmx);
        Optional.ofNullable(CouchbaseSourceTask.newLoggingMeterRegistry(config)).ifPresent(arg_0 -> ((CompositeMeterRegistry)composite).add(arg_0));
        return composite;
    }

    private static @Nullable MeterRegistry newLoggingMeterRegistry(CouchbaseSourceTaskConfig config) {
        Duration interval = config.metricsInterval();
        String configKey = ConfigHelper.keyName(CouchbaseSourceTaskConfig.class, LoggingConfig::metricsInterval);
        if (interval.isZero()) {
            LOGGER.info("Metrics logging is disabled because config property '" + configKey + "' is set to 0.");
            return null;
        }
        String metricsCategory = "com.couchbase.connect.kafka.metrics";
        Logger metricsLogger = LoggerFactory.getLogger((String)metricsCategory);
        LOGGER.info("Will log metrics to logging category '" + metricsCategory + "' at interval: " + interval);
        return LoggingMeterRegistry.builder(k -> "logging.step".equals(k) ? interval.toMillis() + "ms" : null).loggingSink(arg_0 -> ((Logger)metricsLogger).info(arg_0)).build();
    }

    private RedactionLevel toDcp(com.couchbase.client.core.logging.RedactionLevel level) {
        switch (level) {
            case FULL: {
                return RedactionLevel.FULL;
            }
            case NONE: {
                return RedactionLevel.NONE;
            }
            case PARTIAL: {
                return RedactionLevel.PARTIAL;
            }
        }
        throw new IllegalArgumentException("Unrecognized redaction level: " + level);
    }

    public void stop() {
        this.taskLifecycle.logTaskStopped();
        LOGGER.info("Scheduling cleanup because task was asked to stop. taskUuid={}", (Object)this.taskUuid());
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SourceRecord> poll() throws InterruptedException {
        this.timeBetweenPollsTimer.record(this.endOfLastPoll.elapsed());
        this.watchdog.enterState("polling");
        try {
            List<SourceRecord> list;
            this.checkErrorQueue();
            DocumentChange firstEvent = this.queue.poll(1L, TimeUnit.SECONDS);
            if (firstEvent == null) {
                LOGGER.debug("Poll returns 0 results; taskUuid={}", (Object)this.taskUuid());
                this.watchdog.enterState("waiting for next poll (after 0 records)");
                List<SourceRecord> list2 = null;
                return list2;
            }
            ArrayList<DocumentChange> events = new ArrayList<DocumentChange>();
            try {
                this.watchdog.enterState("draining queue");
                events.add(firstEvent);
                this.queue.drainTo(events, this.batchSizeMax - 1);
                this.watchdog.enterState("converting to source records (" + events.size() + " events)");
                ConversionResult results = this.convertToSourceRecords(events);
                this.filteredCounter.increment((double)results.dropped);
                if (results.synthetic > 0) {
                    LOGGER.info("Poll returns {} result(s) ({} synthetic; filtered out {}); taskUuid={}", new Object[]{results.published + results.synthetic, results.synthetic, results.dropped, this.taskUuid()});
                } else {
                    LOGGER.info("Poll returns {} result(s) (filtered out {}); taskUuid={}", new Object[]{results.published, results.dropped, this.taskUuid()});
                }
                this.watchdog.enterState("waiting for next poll (after " + results.records.size() + " records)");
                list = results.records;
            }
            catch (Throwable throwable) {
                try {
                    events.forEach(DocumentChange::flowControlAck);
                    throw throwable;
                }
                catch (Throwable t) {
                    this.watchdog.enterState("polling reported error: " + t);
                    throw t;
                }
            }
            events.forEach(DocumentChange::flowControlAck);
            return list;
        }
        finally {
            this.endOfLastPoll = NanoTimestamp.now();
        }
    }

    private boolean isSourceOffsetUpdate(SourceRecord record) {
        return this.blackHoleTopic.isPresent() && this.blackHoleTopic.get().equals(record.topic());
    }

    public void commitRecord(SourceRecord record, RecordMetadata metadata) {
        if (record instanceof CouchbaseSourceRecord) {
            CouchbaseSourceRecord couchbaseRecord = (CouchbaseSourceRecord)record;
            if (this.isSourceOffsetUpdate(couchbaseRecord)) {
                this.lifecycle.logSourceOffsetUpdateCommittedToBlackHoleTopic(couchbaseRecord, metadata);
            } else {
                this.lifecycle.logCommittedToKafkaTopic(couchbaseRecord, metadata);
            }
        } else {
            LOGGER.warn("Committed a record we didn't create? Record key {}; taskUuid={}", record.key(), (Object)this.taskUuid());
        }
        this.sourceHandler.onRecordCommitted(record, metadata);
    }

    private void checkErrorQueue() throws ConnectException {
        Throwable fatalError = (Throwable)this.errorQueue.poll();
        if (fatalError != null) {
            throw new ConnectException(fatalError);
        }
    }

    private static boolean jsonpathMatch(JsonPath filter, byte[] document) {
        try {
            if (filter == ROOT_JSON_PATH) {
                return true;
            }
            List result = (List)filter.read((InputStream)new ByteArrayInputStream(document), jsonpathConf);
            return !result.isEmpty();
        }
        catch (InvalidJsonException | InvalidPathException | IOException e) {
            return false;
        }
    }

    private String getDefaultTopic(DocumentEvent docEvent) {
        ScopeAndCollection scopeAndCollection = CouchbaseSourceTask.scopeAndCollection(docEvent);
        String topic = this.topicTemplate.get(scopeAndCollection);
        if (topic.contains("${")) {
            return topic.replace("${bucket}", this.bucket).replace("${scope}", scopeAndCollection.getScope()).replace("${collection}", scopeAndCollection.getCollection()).replace("%", "_");
        }
        return topic;
    }

    private ConversionResult convertToSourceRecords(List<DocumentChange> events) {
        ArrayList<SourceRecord> results = new ArrayList<SourceRecord>(events.size());
        int dropped = 0;
        int initialOffsets = 0;
        for (DocumentChange e : events) {
            boolean jsonpathPassed;
            DocumentEvent docEvent = DocumentEvent.create(e, this.bucket);
            if (CouchbaseReader.isSyntheticInitialOffsetTombstone(e) && this.initialOffsetTopic.isPresent()) {
                String topic2 = this.initialOffsetTopic.get();
                SourceRecord sourceRecord = this.createSourceOffsetUpdateRecord(e.getKey(), topic2, e);
                this.lifecycle.logConvertedToKafkaRecord(e, sourceRecord);
                results.add(sourceRecord);
                ++initialOffsets;
                continue;
            }
            if (docEvent.isJson() && !(jsonpathPassed = CouchbaseSourceTask.jsonpathMatch(this.jsonPaths.get(ScopeAndCollection.from(docEvent)), docEvent.content()))) {
                this.lifecycle.logSkippedBecauseJsonpathFilterSaysIgnore(e);
                ++dropped;
                this.blackHoleTopic.ifPresent(topic -> results.add(this.createSourceOffsetUpdateRecord((String)topic, e)));
                continue;
            }
            boolean passed = this.filterTimer.record(() -> this.filter.pass(docEvent));
            if (!passed) {
                this.lifecycle.logSkippedBecauseFilterSaysIgnore(e);
                ++dropped;
                this.blackHoleTopic.ifPresent(topic -> results.add(this.createSourceOffsetUpdateRecord((String)topic, e)));
                continue;
            }
            List<CouchbaseSourceRecord> sourceRecords = this.convertToSourceRecords(e, docEvent);
            if (sourceRecords.isEmpty()) {
                this.lifecycle.logSkippedBecauseHandlerSaysIgnore(e);
                ++dropped;
                this.blackHoleTopic.ifPresent(topic -> results.add(this.createSourceOffsetUpdateRecord((String)topic, e)));
                continue;
            }
            sourceRecords.forEach(it -> this.lifecycle.logConvertedToKafkaRecord(e, (SourceRecord)it));
            results.addAll(sourceRecords);
        }
        int published = results.size() - initialOffsets;
        if (this.blackHoleTopic.isPresent()) {
            published -= dropped;
        }
        return new ConversionResult(results, published, dropped, initialOffsets);
    }

    private SourceRecord createSourceOffsetUpdateRecord(String topic, DocumentChange change) {
        String key = "ignored-" + change.getVbucket();
        return this.createSourceOffsetUpdateRecord(key, topic, change);
    }

    private SourceRecord createSourceOffsetUpdateRecord(String key, String topic, DocumentChange change) {
        return new SourceRecordBuilder().key(key).build(change, this.sourcePartition(change.getVbucket()), CouchbaseSourceTask.sourceOffset(change), topic);
    }

    private List<CouchbaseSourceRecord> convertToSourceRecords(DocumentChange change, DocumentEvent docEvent) {
        String topic = this.getDefaultTopic(docEvent);
        List builders = (List)this.handlerTimer.record(() -> this.sourceHandler.convertToSourceRecords(new SourceHandlerParams(docEvent, topic, this.noValue)));
        Objects.requireNonNull(builders, "The source handler's convertToSourceRecords() method returned null instead of a List; this is forbidden.");
        if (builders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CouchbaseSourceRecord> result = new ArrayList<CouchbaseSourceRecord>(builders.size());
        for (SourceRecordBuilder builder : builders) {
            Objects.requireNonNull(builder, "The source handler's convertToSourceRecords() method returned a list containing a null item; this is forbidden.");
            this.headerSetter.setHeaders(builder.headers(), docEvent);
            CouchbaseSourceRecord record = builder.build(change, this.sourcePartition(docEvent.partition()), CouchbaseSourceTask.sourceOffset(change), topic);
            result.add(record);
        }
        return result;
    }

    private void cleanup() {
        if (this.cleanup.alreadyCalled()) {
            LOGGER.info("Ignoring redundant cleanup request; taskUuid={}", (Object)this.taskUuid());
            return;
        }
        cleanupThreadFactory.newThread(() -> {
            block11: {
                try {
                    Thread.currentThread().setName(Thread.currentThread().getName() + "-" + this.taskUuid());
                    if (this.startupComplete.getCount() != 0L) {
                        LOGGER.info("Task was asked to stop before it finished starting; deferring cleanup until start() completes. taskUuid={}", (Object)this.taskUuid());
                        Duration safeguardTimeout = Duration.ofMinutes(30L);
                        if (!this.startupComplete.await(safeguardTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                            LOGGER.error("This task's start() method did not complete within the safeguard timeout of {}. Making a last-ditch effort to clean up. taskUuid={}", (Object)safeguardTimeout, (Object)this.taskUuid());
                        }
                    }
                    LOGGER.info("Cleaning up now; taskUuid={}", (Object)this.taskUuid());
                    this.watchdog.stop();
                    if (this.meterRegistry != null) {
                        this.meterRegistry.close();
                    }
                    if (this.couchbaseReader == null) break block11;
                    this.couchbaseReader.shutdown();
                    try {
                        this.couchbaseReader.join(STOP_TIMEOUT_MILLIS);
                        if (this.couchbaseReader.isAlive()) {
                            LOGGER.error("Reader thread is still alive after shutdown request.");
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted while joining reader thread.", (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Error while cleaning up resources; taskUuid={}", (Object)this.taskUuid(), (Object)t);
                }
                finally {
                    this.taskLifecycle.logTaskCleanupComplete();
                }
            }
        }).start();
    }

    private Map<Integer, SourceOffset> readSourceOffsets(Collection<Integer> partitions) {
        Map offsets = this.context.offsetStorageReader().offsets(this.sourcePartitions(partitions));
        LOGGER.debug("Raw source offsets: {}; taskUuid={}", (Object)offsets, (Object)this.taskUuid());
        HashSet<Integer> missingPartitions = new HashSet<Integer>(partitions);
        TreeMap<Integer, SourceOffset> partitionToSourceOffset = new TreeMap<Integer, SourceOffset>();
        offsets.forEach((partitionIdentifier, offset) -> {
            int partition = Integer.parseInt((String)partitionIdentifier.get("partition"));
            missingPartitions.remove(partition);
            if (offset != null) {
                partitionToSourceOffset.put(partition, SourceOffset.fromMap(offset));
            }
        });
        if (!missingPartitions.isEmpty()) {
            LOGGER.error("Offset storage reader returned no information about these partitions: {}; taskUuid={}", (Object)PartitionSet.from(missingPartitions), (Object)this.taskUuid());
        }
        return partitionToSourceOffset;
    }

    private List<Map<String, Object>> sourcePartitions(Collection<Integer> partitions) {
        ArrayList<Map<String, Object>> sourcePartitions = new ArrayList<Map<String, Object>>();
        for (Integer partition : partitions) {
            sourcePartitions.add(this.sourcePartition(partition));
        }
        return sourcePartitions;
    }

    private Map<String, Object> sourcePartition(int partition) {
        HashMap<String, Object> sourcePartition = new HashMap<String, Object>(3);
        sourcePartition.put("bucket", this.bucket);
        sourcePartition.put("partition", String.valueOf(partition));
        if (this.connectorNameInOffsets) {
            sourcePartition.put("connector", this.connectorName);
        }
        return sourcePartition;
    }

    private static Map<String, Object> sourceOffset(DocumentChange change) {
        return new SourceOffset(change.getOffset()).toMap();
    }

    private static ScopeAndCollection scopeAndCollection(DocumentEvent docEvent) {
        CollectionMetadata md = docEvent.collectionMetadata();
        return new ScopeAndCollection(md.scopeName(), md.collectionName());
    }

    @NullMarked
    private static MultiSourceHandler createSourceHandler(CouchbaseSourceTaskConfig config) {
        Object handlerObject = Utils.newInstance(config.sourceHandler());
        if (handlerObject instanceof MultiSourceHandler) {
            return (MultiSourceHandler)handlerObject;
        }
        if (!(handlerObject instanceof SourceHandler)) {
            String configKey = ConfigHelper.keyName(CouchbaseSourceTaskConfig.class, SourceBehaviorConfig::sourceHandler);
            throw new ConfigException("Invalid value for connector config property '" + configKey + "' ; Source handler must be an instance of " + SourceHandler.class.getName() + " or " + MultiSourceHandler.class.getName() + ", but got: " + handlerObject.getClass().getName());
        }
        final SourceHandler sourceHandler = (SourceHandler)handlerObject;
        return new MultiSourceHandler(){

            @Override
            public void init(Map<String, String> configProperties) {
                sourceHandler.init(configProperties);
            }

            @Override
            public List<SourceRecordBuilder> convertToSourceRecords(SourceHandlerParams params) {
                SourceRecordBuilder result = sourceHandler.handle(params);
                return result == null ? Collections.emptyList() : Collections.singletonList(result);
            }

            @Override
            public void onRecordCommitted(SourceRecord record, @Nullable RecordMetadata metadata) {
                sourceHandler.onRecordCommitted(record, metadata);
            }
        };
    }

    private static class ConversionResult {
        public final List<SourceRecord> records;
        public final int published;
        public final int dropped;
        public final int synthetic;

        public ConversionResult(List<SourceRecord> records, int published, int dropped, int synthetic) {
            this.records = records;
            this.published = published;
            this.dropped = dropped;
            this.synthetic = synthetic;
        }
    }
}

