/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.sink;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.connect.kafka.config.sink.CouchbaseSinkConfig;
import com.couchbase.connect.kafka.handler.sink.ConcurrencyHint;
import com.couchbase.connect.kafka.handler.sink.SinkAction;
import com.couchbase.connect.kafka.handler.sink.SinkDocument;
import com.couchbase.connect.kafka.handler.sink.SinkHandler;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerContext;
import com.couchbase.connect.kafka.handler.sink.SinkHandlerParams;
import com.couchbase.connect.kafka.util.AnalyticsBatchBuilder;
import com.couchbase.connect.kafka.util.N1qlData;
import com.couchbase.connect.kafka.util.config.ConfigHelper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class AnalyticsSinkHandler
implements SinkHandler {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsSinkHandler.class);
    protected String bucketName;
    protected int maxRecordsInBatchLimit;
    protected long maxSizeOfRecordsInBytesLimit;
    protected Duration analyticsQueryTimeout;

    protected static StatementAndArgs deleteQuery(String keySpace, JsonObject documentKeys) {
        JsonArray values = JsonArray.create();
        String whereClause = documentKeys.getNames().stream().map(key -> {
            values.add(documentKeys.get(key));
            return "`" + key + "`=?";
        }).collect(Collectors.joining(" AND "));
        return new StatementAndArgs("DELETE FROM " + keySpace + " WHERE " + whereClause + ";", values);
    }

    protected static JsonObject getJsonObject(String object) {
        JsonObject node = null;
        try {
            node = JsonObject.fromJson((String)object);
        }
        catch (Exception e) {
            log.warn("could not generate analytics statement from node (not json)", (Throwable)e);
        }
        if (node != null && node.isEmpty()) {
            node = null;
            log.warn("could not generate analytics statement from empty node");
        }
        return node;
    }

    @Override
    public void init(SinkHandlerContext context) {
        CouchbaseSinkConfig config = ConfigHelper.parse(CouchbaseSinkConfig.class, context.configProperties());
        this.maxRecordsInBatchLimit = config.analyticsMaxRecordsInBatch();
        this.maxSizeOfRecordsInBytesLimit = config.analyticsMaxSizeInBatch().getByteCount();
        this.analyticsQueryTimeout = config.analyticsQueryTimeout();
        this.bucketName = config.bucket();
    }

    @Override
    public boolean usesKvCollections() {
        return false;
    }

    private String upsertStatement(String keySpace, JsonObject values) {
        return "UPSERT INTO " + keySpace + " ([" + values + "]);";
    }

    @Override
    public SinkAction handle(SinkHandlerParams params) {
        String documentKeys = this.getDocumentId(params);
        SinkDocument doc = params.document().orElse(null);
        String keySpace = params.getKeyspace().format();
        if (doc != null) {
            String docContent = new String(doc.content(), StandardCharsets.UTF_8);
            if (docContent.contains("`")) {
                log.warn("Could not generate Analytics N1QL UPSERT statement with backtick (`) in document content");
                return SinkAction.ignore();
            }
            JsonObject node = AnalyticsSinkHandler.getJsonObject(docContent);
            if (node == null) {
                return SinkAction.ignore();
            }
            String statement = this.upsertStatement(keySpace, node);
            Mono action = Mono.defer(() -> params.cluster().analyticsQuery(statement, ((AnalyticsOptions)AnalyticsOptions.analyticsOptions().timeout(this.analyticsQueryTimeout)).parameters(node)).map(ReactiveAnalyticsResult::metaData));
            ConcurrencyHint concurrencyHint = ConcurrencyHint.of(documentKeys);
            return new SinkAction((Publisher<?>)action, concurrencyHint);
        }
        if (documentKeys.contains("`")) {
            log.warn("Could not generate Analytics N1QL DELETE statement with backtick (`) in field name");
            return SinkAction.ignore();
        }
        JsonObject documentKeysJson = AnalyticsSinkHandler.getJsonObject(documentKeys);
        if (documentKeysJson == null) {
            return SinkAction.ignore();
        }
        StatementAndArgs deleteQuery = AnalyticsSinkHandler.deleteQuery(keySpace, documentKeysJson);
        Mono action = Mono.defer(() -> params.cluster().analyticsQuery(deleteQuery.statement(), ((AnalyticsOptions)AnalyticsOptions.analyticsOptions().timeout(this.analyticsQueryTimeout)).parameters(deleteQuery.args())).map(ReactiveAnalyticsResult::metaData));
        ConcurrencyHint concurrencyHint = ConcurrencyHint.of(documentKeys);
        return new SinkAction((Publisher<?>)action, concurrencyHint);
    }

    @Override
    public List<SinkAction> handleBatch(List<SinkHandlerParams> params) {
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        AnalyticsBatchBuilder batchBuilder = new AnalyticsBatchBuilder(this.maxSizeOfRecordsInBytesLimit, this.maxRecordsInBatchLimit);
        ReactiveCluster cluster = params.get(0).cluster();
        for (SinkHandlerParams param : params) {
            String documentIds = this.getDocumentId(param);
            SinkDocument doc = param.document().orElse(null);
            String keySpace = param.getKeyspace().format();
            if (doc != null) {
                JsonObject node;
                try {
                    node = JsonObject.fromJson((byte[])doc.content());
                }
                catch (Exception e) {
                    log.warn("could not generate n1ql statement from node (not json)", (Throwable)e);
                    continue;
                }
                if (node.isEmpty()) {
                    log.warn("could not generate n1ql statement from node (not json)");
                    continue;
                }
                boolean backTicksFoundInKeys = false;
                for (String name : node.getNames()) {
                    if (!name.contains("`")) continue;
                    backTicksFoundInKeys = true;
                    log.warn("could not generate n1ql statement from node with backtick (`) in field name");
                    break;
                }
                if (backTicksFoundInKeys) continue;
                batchBuilder.add(new N1qlData(keySpace, node.toString(), N1qlData.OperationType.UPSERT, ConcurrencyHint.of(documentIds)));
                continue;
            }
            if (documentIds.contains("`")) {
                log.warn("Could not generate Analytics N1QL DELETE statement with backtick (`) in field name");
                continue;
            }
            JsonObject documentKeysJson = AnalyticsSinkHandler.getJsonObject(documentIds);
            if (documentKeysJson == null) continue;
            String deleteCondition = this.generateDeleteCondition(documentKeysJson);
            batchBuilder.add(new N1qlData(keySpace, deleteCondition, N1qlData.OperationType.DELETE, ConcurrencyHint.of(documentIds)));
        }
        return batchBuilder.build().stream().map(statement -> new SinkAction((Publisher<?>)Mono.defer(() -> cluster.analyticsQuery(statement, (AnalyticsOptions)AnalyticsOptions.analyticsOptions().timeout(this.analyticsQueryTimeout)).map(ReactiveAnalyticsResult::metaData)), ConcurrencyHint.neverConcurrent())).collect(Collectors.toList());
    }

    private String generateDeleteCondition(JsonObject documentKeysJson) {
        String condition = documentKeysJson.getNames().stream().map(key -> {
            Object value = documentKeysJson.get(key);
            if (value instanceof Number) {
                return String.format("%s=%s", key, value);
            }
            return String.format("%s=\"%s\"", key, value);
        }).collect(Collectors.joining(" AND "));
        return " ( " + condition + " ) ";
    }

    public String toString() {
        return "AnalyticsSinkHandler{, bucketName='" + this.bucketName + '\'' + '}';
    }

    protected static final class StatementAndArgs {
        private final String statement;
        private final JsonArray args;

        public StatementAndArgs(String statement, JsonArray args) {
            this.statement = Objects.requireNonNull(statement);
            this.args = Objects.requireNonNull(args);
        }

        public String statement() {
            return this.statement;
        }

        public JsonArray args() {
            return this.args;
        }
    }
}

