/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class JsonHelper {
    private static final JsonFactory jsonFactory = new JsonFactory();

    private JsonHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean isValidJson(byte[] bytes) {
        try {
            JsonToken token;
            JsonToken decrementDepthToken;
            JsonToken incrementDepthToken;
            JsonParser parser = jsonFactory.createParser(bytes);
            JsonToken firstToken = parser.nextToken();
            if (firstToken == JsonToken.START_OBJECT) {
                incrementDepthToken = JsonToken.START_OBJECT;
                decrementDepthToken = JsonToken.END_OBJECT;
            } else if (firstToken == JsonToken.START_ARRAY) {
                incrementDepthToken = JsonToken.START_ARRAY;
                decrementDepthToken = JsonToken.END_ARRAY;
            } else {
                return firstToken != null && parser.nextToken() == null;
            }
            int depth = 1;
            while ((token = parser.nextToken()) != null) {
                if (token == incrementDepthToken) {
                    ++depth;
                    continue;
                }
                if (token != decrementDepthToken || --depth != 0 || parser.nextToken() == null) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

