//
//  CBLDefaults.h
//  CouchbaseLite
//
//  Copyright (c) 2024-present Couchbase, Inc All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

// THIS IS AN AUTOGENERATED FILE, MANUAL CHANGES SHOULD BE EXPECTED TO
// BE OVERWRITTEN


#pragma once
#include "CBL_Compat.h"
#include "CBLReplicator.h"
#include "CBLQueryIndexTypes.h"

CBL_CAPI_BEGIN

/** \defgroup constants   Constants

     @{

    Constants for default configuration values. */

/** \name CBLDatabaseConfiguration
    @{
*/

/** [false] Full sync is off by default because the performance hit is seldom worth the benefit */
CBL_PUBLIC extern const bool kCBLDefaultDatabaseFullSync;

/** [false] Memory mapped database files are enabled by default */
CBL_PUBLIC extern const bool kCBLDefaultDatabaseMmapDisabled;

/** @} */

/** \name CBLLogFileConfiguration
    @{
*/

/** [false] Plaintext is not used, and instead binary encoding is used in log files */
CBL_PUBLIC extern const bool kCBLDefaultLogFileUsePlaintext;

/** [524288] 512 KiB for the size of a log file */
CBL_PUBLIC extern const size_t kCBLDefaultLogFileMaxSize;

/** [1] 1 rotated file present (2 total, including the currently active log file) */
CBL_PUBLIC extern const uint32_t kCBLDefaultLogFileMaxRotateCount;

/** @} */

/** \name CBLFileLogSink
    @{
*/

/** [false] Plaintext is not used, and instead binary encoding is used in log files */
CBL_PUBLIC extern const bool kCBLDefaultFileLogSinkUsePlaintext;

/** [524288] 512 KiB for the size of a log file */
CBL_PUBLIC extern const size_t kCBLDefaultFileLogSinkMaxSize;

/** [2] 2 files preserved during each log rotation */
CBL_PUBLIC extern const uint32_t kCBLDefaultFileLogSinkMaxKeptFiles;

/** @} */

/** \name CBLFullTextIndexConfiguration
    @{
*/

/** [false] Accents and ligatures are not ignored when indexing via full text search */
CBL_PUBLIC extern const bool kCBLDefaultFullTextIndexIgnoreAccents;

/** @} */

/** \name CBLReplicatorConfiguration
    @{
*/

/** [kCBLReplicatorTypePushAndPull] Perform bidirectional replication */
CBL_PUBLIC extern const CBLReplicatorType kCBLDefaultReplicatorType;

/** [false] One-shot replication is used, and will stop once all initial changes are processed */
CBL_PUBLIC extern const bool kCBLDefaultReplicatorContinuous;

/** [300] A heartbeat messages is sent every 300 seconds to keep the connection alive */
CBL_PUBLIC extern const unsigned kCBLDefaultReplicatorHeartbeat;

/** [10] When replicator is not continuous, after 10 failed attempts give up on the replication */
CBL_PUBLIC extern const unsigned kCBLDefaultReplicatorMaxAttemptsSingleShot;

/** [UINT_MAX] When replicator is continuous, never give up unless explicitly stopped */
CBL_PUBLIC extern const unsigned kCBLDefaultReplicatorMaxAttemptsContinuous;

/** [300] Max wait time between retry attempts in seconds */
CBL_PUBLIC extern const unsigned kCBLDefaultReplicatorMaxAttemptsWaitTime;

/** [false] Purge documents when a user loses access */
CBL_PUBLIC extern const bool kCBLDefaultReplicatorDisableAutoPurge;

/** [false] Whether or not a replicator only accepts cookies for the sender's parent domains */
CBL_PUBLIC extern const bool kCBLDefaultReplicatorAcceptParentCookies;

/** @} */

#ifdef COUCHBASE_ENTERPRISE

/** \name CBLVectorIndexConfiguration
    @{
*/

/** [false] Vectors are not lazily indexed, by default */
CBL_PUBLIC extern const bool kCBLDefaultVectorIndexLazy;

/** [kCBLDistanceMetricEuclideanSquared] By default, vectors are compared using Squared Euclidean metric. */
CBL_PUBLIC extern const CBLDistanceMetric kCBLDefaultVectorIndexDistanceMetric;

/** [0] By default, the value will be determined based on the number of centroids, encoding types, and the encoding parameters. */
CBL_PUBLIC extern const unsigned kCBLDefaultVectorIndexMinTrainingSize;

/** [0] By default, the value will be determined based on the number of centroids, encoding types, and the encoding parameters */
CBL_PUBLIC extern const unsigned kCBLDefaultVectorIndexMaxTrainingSize;

/** [0] By default, the value will be determined based on the number of centroids. */
CBL_PUBLIC extern const unsigned kCBLDefaultVectorIndexNumProbes;

/** @} */

#endif

/** @} */

CBL_CAPI_END
